/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreateWorkflowStatusDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreateWorkflowTransitionDetails;

/**
 * The details of a workflow.
 */
@ApiModel(description = "The details of a workflow.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class CreateWorkflowDetails {
  @JsonProperty("description")
  private String description;

  @JsonProperty("name")
  private String name;

  @JsonProperty("statuses")
  private List<CreateWorkflowStatusDetails> statuses = new ArrayList<>();

  @JsonProperty("transitions")
  private List<CreateWorkflowTransitionDetails> transitions = new ArrayList<>();

  public CreateWorkflowDetails description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the workflow. The maximum length is 1000 characters.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the workflow. The maximum length is 1000 characters.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CreateWorkflowDetails name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the workflow. The name must be unique. The maximum length is 255 characters. Characters can be separated by a whitespace but the name cannot start or end with a whitespace.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the workflow. The name must be unique. The maximum length is 255 characters. Characters can be separated by a whitespace but the name cannot start or end with a whitespace.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CreateWorkflowDetails statuses(List<CreateWorkflowStatusDetails> statuses) {
    this.statuses = statuses;
    return this;
  }

  public CreateWorkflowDetails addStatusesItem(CreateWorkflowStatusDetails statusesItem) {
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * The statuses of the workflow. Any status that does not include a transition is added to the workflow without a transition.
   * @return statuses
  **/
  @ApiModelProperty(required = true, value = "The statuses of the workflow. Any status that does not include a transition is added to the workflow without a transition.")
  public List<CreateWorkflowStatusDetails> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<CreateWorkflowStatusDetails> statuses) {
    this.statuses = statuses;
  }

  public CreateWorkflowDetails transitions(List<CreateWorkflowTransitionDetails> transitions) {
    this.transitions = transitions;
    return this;
  }

  public CreateWorkflowDetails addTransitionsItem(CreateWorkflowTransitionDetails transitionsItem) {
    this.transitions.add(transitionsItem);
    return this;
  }

   /**
   * The transitions of the workflow. For the request to be valid, these transitions must:   *  include one *initial* transition.  *  not use the same name for a *global* and *directed* transition.  *  have a unique name for each *global* transition.  *  have a unique &#39;to&#39; status for each *global* transition.  *  have unique names for each transition from a status.  *  not have a &#39;from&#39; status on *initial* and *global* transitions.  *  have a &#39;from&#39; status on *directed* transitions.  All the transition statuses must be included in &#x60;statuses&#x60;.
   * @return transitions
  **/
  @ApiModelProperty(required = true, value = "The transitions of the workflow. For the request to be valid, these transitions must:   *  include one *initial* transition.  *  not use the same name for a *global* and *directed* transition.  *  have a unique name for each *global* transition.  *  have a unique 'to' status for each *global* transition.  *  have unique names for each transition from a status.  *  not have a 'from' status on *initial* and *global* transitions.  *  have a 'from' status on *directed* transitions.  All the transition statuses must be included in `statuses`.")
  public List<CreateWorkflowTransitionDetails> getTransitions() {
    return transitions;
  }

  public void setTransitions(List<CreateWorkflowTransitionDetails> transitions) {
    this.transitions = transitions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateWorkflowDetails createWorkflowDetails = (CreateWorkflowDetails) o;
    return Objects.equals(this.description, createWorkflowDetails.description) &&
        Objects.equals(this.name, createWorkflowDetails.name) &&
        Objects.equals(this.statuses, createWorkflowDetails.statuses) &&
        Objects.equals(this.transitions, createWorkflowDetails.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, name, statuses, transitions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateWorkflowDetails {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

