/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Details of the contextual configuration for a custom field.
 */
@ApiModel(description = "Details of the contextual configuration for a custom field.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class ContextualConfiguration {
  @JsonProperty("configuration")
  private Object _configuration = null;

  @JsonProperty("fieldContextId")
  private String fieldContextId;

  @JsonProperty("id")
  private String id;

  @JsonProperty("schema")
  private Object schema = null;

  public ContextualConfiguration _configuration(Object _configuration) {
    this._configuration = _configuration;
    return this;
  }

   /**
   * The field configuration.
   * @return _configuration
  **/
  @ApiModelProperty(value = "The field configuration.")
  public Object getConfiguration() {
    return _configuration;
  }

  public void setConfiguration(Object _configuration) {
    this._configuration = _configuration;
  }

   /**
   * The ID of the field context the configuration is associated with.
   * @return fieldContextId
  **/
  @ApiModelProperty(required = true, value = "The ID of the field context the configuration is associated with.")
  public String getFieldContextId() {
    return fieldContextId;
  }

  public ContextualConfiguration id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the configuration.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The ID of the configuration.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public ContextualConfiguration schema(Object schema) {
    this.schema = schema;
    return this;
  }

   /**
   * The field value schema.
   * @return schema
  **/
  @ApiModelProperty(value = "The field value schema.")
  public Object getSchema() {
    return schema;
  }

  public void setSchema(Object schema) {
    this.schema = schema;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContextualConfiguration contextualConfiguration = (ContextualConfiguration) o;
    return Objects.equals(this._configuration, contextualConfiguration._configuration) &&
        Objects.equals(this.fieldContextId, contextualConfiguration.fieldContextId) &&
        Objects.equals(this.id, contextualConfiguration.id) &&
        Objects.equals(this.schema, contextualConfiguration.schema);
  }

  @Override
  public int hashCode() {
    return Objects.hash(_configuration, fieldContextId, id, schema);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContextualConfiguration {\n");
    
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    fieldContextId: ").append(toIndentedString(fieldContextId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

