/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.EntityProperty;

/**
 * Details of a changed worklog.
 */
@ApiModel(description = "Details of a changed worklog.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class ChangedWorklog {
  @JsonProperty("properties")
  private List<EntityProperty> properties = new ArrayList<>();

  @JsonProperty("updatedTime")
  private Long updatedTime;

  @JsonProperty("worklogId")
  private Long worklogId;

   /**
   * Details of properties associated with the change.
   * @return properties
  **/
  @ApiModelProperty(value = "Details of properties associated with the change.")
  public List<EntityProperty> getProperties() {
    return properties;
  }

   /**
   * The datetime of the change.
   * @return updatedTime
  **/
  @ApiModelProperty(value = "The datetime of the change.")
  public Long getUpdatedTime() {
    return updatedTime;
  }

   /**
   * The ID of the worklog.
   * @return worklogId
  **/
  @ApiModelProperty(value = "The ID of the worklog.")
  public Long getWorklogId() {
    return worklogId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChangedWorklog changedWorklog = (ChangedWorklog) o;
    return Objects.equals(this.properties, changedWorklog.properties) &&
        Objects.equals(this.updatedTime, changedWorklog.updatedTime) &&
        Objects.equals(this.worklogId, changedWorklog.worklogId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(properties, updatedTime, worklogId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChangedWorklog {\n");
    
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    updatedTime: ").append(toIndentedString(updatedTime)).append("\n");
    sb.append("    worklogId: ").append(toIndentedString(worklogId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

