/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkEditActionError;

/**
 * Details of a request to bulk edit shareable entity.
 */
@ApiModel(description = "Details of a request to bulk edit shareable entity.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class BulkEditShareableEntityResponse {
  /**
   * Allowed action for bulk edit shareable entity
   */
  public enum ActionEnum {
    CHANGEOWNER("changeOwner"),
    
    CHANGEPERMISSION("changePermission"),
    
    ADDPERMISSION("addPermission"),
    
    REMOVEPERMISSION("removePermission");

    private String value;

    ActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActionEnum fromValue(String value) {
      for (ActionEnum b : ActionEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("action")
  private ActionEnum action;

  @JsonProperty("entityErrors")
  private Map<String, BulkEditActionError> entityErrors = new HashMap<>();

  public BulkEditShareableEntityResponse action(ActionEnum action) {
    this.action = action;
    return this;
  }

   /**
   * Allowed action for bulk edit shareable entity
   * @return action
  **/
  @ApiModelProperty(required = true, value = "Allowed action for bulk edit shareable entity")
  public ActionEnum getAction() {
    return action;
  }

  public void setAction(ActionEnum action) {
    this.action = action;
  }

  public BulkEditShareableEntityResponse entityErrors(Map<String, BulkEditActionError> entityErrors) {
    this.entityErrors = entityErrors;
    return this;
  }

  public BulkEditShareableEntityResponse putEntityErrorsItem(String key, BulkEditActionError entityErrorsItem) {
    if (this.entityErrors == null) {
      this.entityErrors = new HashMap<>();
    }
    this.entityErrors.put(key, entityErrorsItem);
    return this;
  }

   /**
   * The mapping dashboard id to errors if any.
   * @return entityErrors
  **/
  @ApiModelProperty(value = "The mapping dashboard id to errors if any.")
  public Map<String, BulkEditActionError> getEntityErrors() {
    return entityErrors;
  }

  public void setEntityErrors(Map<String, BulkEditActionError> entityErrors) {
    this.entityErrors = entityErrors;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkEditShareableEntityResponse bulkEditShareableEntityResponse = (BulkEditShareableEntityResponse) o;
    return Objects.equals(this.action, bulkEditShareableEntityResponse.action) &&
        Objects.equals(this.entityErrors, bulkEditShareableEntityResponse.entityErrors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(action, entityErrors);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkEditShareableEntityResponse {\n");
    
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    entityErrors: ").append(toIndentedString(entityErrors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

