/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkChangeOwnerDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionDetails;

/**
 * Details of a request to bulk edit shareable entity.
 */
@ApiModel(description = "Details of a request to bulk edit shareable entity.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class BulkEditShareableEntityRequest {
  /**
   * Allowed action for bulk edit shareable entity
   */
  public enum ActionEnum {
    CHANGEOWNER("changeOwner"),
    
    CHANGEPERMISSION("changePermission"),
    
    ADDPERMISSION("addPermission"),
    
    REMOVEPERMISSION("removePermission");

    private String value;

    ActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActionEnum fromValue(String value) {
      for (ActionEnum b : ActionEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("action")
  private ActionEnum action;

  @JsonProperty("changeOwnerDetails")
  private BulkChangeOwnerDetails changeOwnerDetails;

  @JsonProperty("entityIds")
  private List<Long> entityIds = new ArrayList<>();

  @JsonProperty("extendAdminPermissions")
  private Boolean extendAdminPermissions;

  @JsonProperty("permissionDetails")
  private PermissionDetails permissionDetails;

  public BulkEditShareableEntityRequest action(ActionEnum action) {
    this.action = action;
    return this;
  }

   /**
   * Allowed action for bulk edit shareable entity
   * @return action
  **/
  @ApiModelProperty(required = true, value = "Allowed action for bulk edit shareable entity")
  public ActionEnum getAction() {
    return action;
  }

  public void setAction(ActionEnum action) {
    this.action = action;
  }

  public BulkEditShareableEntityRequest changeOwnerDetails(BulkChangeOwnerDetails changeOwnerDetails) {
    this.changeOwnerDetails = changeOwnerDetails;
    return this;
  }

   /**
   * The details of change owner action.
   * @return changeOwnerDetails
  **/
  @ApiModelProperty(value = "The details of change owner action.")
  public BulkChangeOwnerDetails getChangeOwnerDetails() {
    return changeOwnerDetails;
  }

  public void setChangeOwnerDetails(BulkChangeOwnerDetails changeOwnerDetails) {
    this.changeOwnerDetails = changeOwnerDetails;
  }

  public BulkEditShareableEntityRequest entityIds(List<Long> entityIds) {
    this.entityIds = entityIds;
    return this;
  }

  public BulkEditShareableEntityRequest addEntityIdsItem(Long entityIdsItem) {
    this.entityIds.add(entityIdsItem);
    return this;
  }

   /**
   * The id list of shareable entities to be changed.
   * @return entityIds
  **/
  @ApiModelProperty(required = true, value = "The id list of shareable entities to be changed.")
  public List<Long> getEntityIds() {
    return entityIds;
  }

  public void setEntityIds(List<Long> entityIds) {
    this.entityIds = entityIds;
  }

  public BulkEditShareableEntityRequest extendAdminPermissions(Boolean extendAdminPermissions) {
    this.extendAdminPermissions = extendAdminPermissions;
    return this;
  }

   /**
   * Whether the actions are executed by users with Administer Jira global permission.
   * @return extendAdminPermissions
  **/
  @ApiModelProperty(value = "Whether the actions are executed by users with Administer Jira global permission.")
  public Boolean getExtendAdminPermissions() {
    return extendAdminPermissions;
  }

  public void setExtendAdminPermissions(Boolean extendAdminPermissions) {
    this.extendAdminPermissions = extendAdminPermissions;
  }

  public BulkEditShareableEntityRequest permissionDetails(PermissionDetails permissionDetails) {
    this.permissionDetails = permissionDetails;
    return this;
  }

   /**
   * The permission details to be changed.
   * @return permissionDetails
  **/
  @ApiModelProperty(value = "The permission details to be changed.")
  public PermissionDetails getPermissionDetails() {
    return permissionDetails;
  }

  public void setPermissionDetails(PermissionDetails permissionDetails) {
    this.permissionDetails = permissionDetails;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkEditShareableEntityRequest bulkEditShareableEntityRequest = (BulkEditShareableEntityRequest) o;
    return Objects.equals(this.action, bulkEditShareableEntityRequest.action) &&
        Objects.equals(this.changeOwnerDetails, bulkEditShareableEntityRequest.changeOwnerDetails) &&
        Objects.equals(this.entityIds, bulkEditShareableEntityRequest.entityIds) &&
        Objects.equals(this.extendAdminPermissions, bulkEditShareableEntityRequest.extendAdminPermissions) &&
        Objects.equals(this.permissionDetails, bulkEditShareableEntityRequest.permissionDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(action, changeOwnerDetails, entityIds, extendAdminPermissions, permissionDetails);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkEditShareableEntityRequest {\n");
    
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    changeOwnerDetails: ").append(toIndentedString(changeOwnerDetails)).append("\n");
    sb.append("    entityIds: ").append(toIndentedString(entityIds)).append("\n");
    sb.append("    extendAdminPermissions: ").append(toIndentedString(extendAdminPermissions)).append("\n");
    sb.append("    permissionDetails: ").append(toIndentedString(permissionDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

