/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.OldToNewSecurityLevelMappingsBean;

/**
 * Issue security scheme, project, and remapping details.
 */
@ApiModel(description = "Issue security scheme, project, and remapping details.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class AssociateSecuritySchemeWithProjectDetails {
  @JsonProperty("oldToNewSecurityLevelMappings")
  private List<OldToNewSecurityLevelMappingsBean> oldToNewSecurityLevelMappings = new ArrayList<>();

  @JsonProperty("projectId")
  private String projectId;

  @JsonProperty("schemeId")
  private String schemeId;

  public AssociateSecuritySchemeWithProjectDetails oldToNewSecurityLevelMappings(List<OldToNewSecurityLevelMappingsBean> oldToNewSecurityLevelMappings) {
    this.oldToNewSecurityLevelMappings = oldToNewSecurityLevelMappings;
    return this;
  }

  public AssociateSecuritySchemeWithProjectDetails addOldToNewSecurityLevelMappingsItem(OldToNewSecurityLevelMappingsBean oldToNewSecurityLevelMappingsItem) {
    if (this.oldToNewSecurityLevelMappings == null) {
      this.oldToNewSecurityLevelMappings = new ArrayList<>();
    }
    this.oldToNewSecurityLevelMappings.add(oldToNewSecurityLevelMappingsItem);
    return this;
  }

   /**
   * The list of scheme levels which should be remapped to new levels of the issue security scheme.
   * @return oldToNewSecurityLevelMappings
  **/
  @ApiModelProperty(value = "The list of scheme levels which should be remapped to new levels of the issue security scheme.")
  public List<OldToNewSecurityLevelMappingsBean> getOldToNewSecurityLevelMappings() {
    return oldToNewSecurityLevelMappings;
  }

  public void setOldToNewSecurityLevelMappings(List<OldToNewSecurityLevelMappingsBean> oldToNewSecurityLevelMappings) {
    this.oldToNewSecurityLevelMappings = oldToNewSecurityLevelMappings;
  }

  public AssociateSecuritySchemeWithProjectDetails projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * The ID of the project.
   * @return projectId
  **/
  @ApiModelProperty(required = true, value = "The ID of the project.")
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public AssociateSecuritySchemeWithProjectDetails schemeId(String schemeId) {
    this.schemeId = schemeId;
    return this;
  }

   /**
   * The ID of the issue security scheme. Providing null will clear the association with the issue security scheme.
   * @return schemeId
  **/
  @ApiModelProperty(required = true, value = "The ID of the issue security scheme. Providing null will clear the association with the issue security scheme.")
  public String getSchemeId() {
    return schemeId;
  }

  public void setSchemeId(String schemeId) {
    this.schemeId = schemeId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AssociateSecuritySchemeWithProjectDetails associateSecuritySchemeWithProjectDetails = (AssociateSecuritySchemeWithProjectDetails) o;
    return Objects.equals(this.oldToNewSecurityLevelMappings, associateSecuritySchemeWithProjectDetails.oldToNewSecurityLevelMappings) &&
        Objects.equals(this.projectId, associateSecuritySchemeWithProjectDetails.projectId) &&
        Objects.equals(this.schemeId, associateSecuritySchemeWithProjectDetails.schemeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldToNewSecurityLevelMappings, projectId, schemeId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AssociateSecuritySchemeWithProjectDetails {\n");
    
    sb.append("    oldToNewSecurityLevelMappings: ").append(toIndentedString(oldToNewSecurityLevelMappings)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    schemeId: ").append(toIndentedString(schemeId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

