/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Configuration of the announcement banner.
 */
@ApiModel(description = "Configuration of the announcement banner.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class AnnouncementBannerConfigurationUpdate {
  @JsonProperty("isDismissible")
  private Boolean isDismissible;

  @JsonProperty("isEnabled")
  private Boolean isEnabled;

  @JsonProperty("message")
  private String message;

  @JsonProperty("visibility")
  private String visibility;

  public AnnouncementBannerConfigurationUpdate isDismissible(Boolean isDismissible) {
    this.isDismissible = isDismissible;
    return this;
  }

   /**
   * Flag indicating if the announcement banner can be dismissed by the user.
   * @return isDismissible
  **/
  @ApiModelProperty(value = "Flag indicating if the announcement banner can be dismissed by the user.")
  public Boolean getIsDismissible() {
    return isDismissible;
  }

  public void setIsDismissible(Boolean isDismissible) {
    this.isDismissible = isDismissible;
  }

  public AnnouncementBannerConfigurationUpdate isEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
    return this;
  }

   /**
   * Flag indicating if the announcement banner is enabled or not.
   * @return isEnabled
  **/
  @ApiModelProperty(value = "Flag indicating if the announcement banner is enabled or not.")
  public Boolean getIsEnabled() {
    return isEnabled;
  }

  public void setIsEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
  }

  public AnnouncementBannerConfigurationUpdate message(String message) {
    this.message = message;
    return this;
  }

   /**
   * The text on the announcement banner.
   * @return message
  **/
  @ApiModelProperty(value = "The text on the announcement banner.")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public AnnouncementBannerConfigurationUpdate visibility(String visibility) {
    this.visibility = visibility;
    return this;
  }

   /**
   * Visibility of the announcement banner. Can be public or private.
   * @return visibility
  **/
  @ApiModelProperty(value = "Visibility of the announcement banner. Can be public or private.")
  public String getVisibility() {
    return visibility;
  }

  public void setVisibility(String visibility) {
    this.visibility = visibility;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnnouncementBannerConfigurationUpdate announcementBannerConfigurationUpdate = (AnnouncementBannerConfigurationUpdate) o;
    return Objects.equals(this.isDismissible, announcementBannerConfigurationUpdate.isDismissible) &&
        Objects.equals(this.isEnabled, announcementBannerConfigurationUpdate.isEnabled) &&
        Objects.equals(this.message, announcementBannerConfigurationUpdate.message) &&
        Objects.equals(this.visibility, announcementBannerConfigurationUpdate.visibility);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isDismissible, isEnabled, message, visibility);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnnouncementBannerConfigurationUpdate {\n");
    
    sb.append("    isDismissible: ").append(toIndentedString(isDismissible)).append("\n");
    sb.append("    isEnabled: ").append(toIndentedString(isEnabled)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

