/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * ActorsMap
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class ActorsMap {
  @JsonProperty("group")
  private List<String> group = new ArrayList<>();

  @JsonProperty("groupId")
  private List<String> groupId = new ArrayList<>();

  @JsonProperty("user")
  private List<String> user = new ArrayList<>();

  public ActorsMap group(List<String> group) {
    this.group = group;
    return this;
  }

  public ActorsMap addGroupItem(String groupItem) {
    if (this.group == null) {
      this.group = new ArrayList<>();
    }
    this.group.add(groupItem);
    return this;
  }

   /**
   * The name of the group to add. This parameter cannot be used with the &#x60;groupId&#x60; parameter. As a group&#39;s name can change, use of &#x60;groupId&#x60; is recommended.
   * @return group
  **/
  @ApiModelProperty(value = "The name of the group to add. This parameter cannot be used with the `groupId` parameter. As a group's name can change, use of `groupId` is recommended.")
  public List<String> getGroup() {
    return group;
  }

  public void setGroup(List<String> group) {
    this.group = group;
  }

  public ActorsMap groupId(List<String> groupId) {
    this.groupId = groupId;
    return this;
  }

  public ActorsMap addGroupIdItem(String groupIdItem) {
    if (this.groupId == null) {
      this.groupId = new ArrayList<>();
    }
    this.groupId.add(groupIdItem);
    return this;
  }

   /**
   * The ID of the group to add. This parameter cannot be used with the &#x60;group&#x60; parameter.
   * @return groupId
  **/
  @ApiModelProperty(value = "The ID of the group to add. This parameter cannot be used with the `group` parameter.")
  public List<String> getGroupId() {
    return groupId;
  }

  public void setGroupId(List<String> groupId) {
    this.groupId = groupId;
  }

  public ActorsMap user(List<String> user) {
    this.user = user;
    return this;
  }

  public ActorsMap addUserItem(String userItem) {
    if (this.user == null) {
      this.user = new ArrayList<>();
    }
    this.user.add(userItem);
    return this;
  }

   /**
   * The user account ID of the user to add.
   * @return user
  **/
  @ApiModelProperty(value = "The user account ID of the user to add.")
  public List<String> getUser() {
    return user;
  }

  public void setUser(List<String> user) {
    this.user = user;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActorsMap actorsMap = (ActorsMap) o;
    return Objects.equals(this.group, actorsMap.group) &&
        Objects.equals(this.groupId, actorsMap.groupId) &&
        Objects.equals(this.user, actorsMap.user);
  }

  @Override
  public int hashCode() {
    return Objects.hash(group, groupId, user);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActorsMap {\n");
    
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

