/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.User;

@ApiModel(description="Details about a workflow scheme.")
public class WorkflowScheme {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="defaultWorkflow")
    private String defaultWorkflow;
    @JsonProperty(value="issueTypeMappings")
    private Map<String, String> issueTypeMappings = new HashMap<String, String>();
    @JsonProperty(value="originalDefaultWorkflow")
    private String originalDefaultWorkflow;
    @JsonProperty(value="originalIssueTypeMappings")
    private Map<String, String> originalIssueTypeMappings = new HashMap<String, String>();
    @JsonProperty(value="draft")
    private Boolean draft;
    @JsonProperty(value="lastModifiedUser")
    private User lastModifiedUser;
    @JsonProperty(value="lastModified")
    private String lastModified;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="updateDraftIfNeeded")
    private Boolean updateDraftIfNeeded;
    @JsonProperty(value="issueTypes")
    private Map<String, IssueTypeDetails> issueTypes = new HashMap<String, IssueTypeDetails>();

    @ApiModelProperty(value="The ID of the workflow scheme.")
    public Long getId() {
        return this.id;
    }

    public WorkflowScheme name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the workflow scheme. The name must be unique. The maximum length is 255 characters. Required when creating a workflow scheme.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowScheme description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the workflow scheme.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowScheme defaultWorkflow(String defaultWorkflow) {
        this.defaultWorkflow = defaultWorkflow;
        return this;
    }

    @ApiModelProperty(value="The name of the default workflow for the workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira. If `defaultWorkflow` is not specified when creating a workflow scheme, it is set to *Jira Workflow (jira)*.")
    public String getDefaultWorkflow() {
        return this.defaultWorkflow;
    }

    public void setDefaultWorkflow(String defaultWorkflow) {
        this.defaultWorkflow = defaultWorkflow;
    }

    public WorkflowScheme issueTypeMappings(Map<String, String> issueTypeMappings) {
        this.issueTypeMappings = issueTypeMappings;
        return this;
    }

    public WorkflowScheme putIssueTypeMappingsItem(String key, String issueTypeMappingsItem) {
        if (this.issueTypeMappings == null) {
            this.issueTypeMappings = new HashMap<String, String>();
        }
        this.issueTypeMappings.put(key, issueTypeMappingsItem);
        return this;
    }

    @ApiModelProperty(value="The issue type to workflow mappings, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.")
    public Map<String, String> getIssueTypeMappings() {
        return this.issueTypeMappings;
    }

    public void setIssueTypeMappings(Map<String, String> issueTypeMappings) {
        this.issueTypeMappings = issueTypeMappings;
    }

    @ApiModelProperty(value="For draft workflow schemes, this property is the name of the default workflow for the original workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira.")
    public String getOriginalDefaultWorkflow() {
        return this.originalDefaultWorkflow;
    }

    @ApiModelProperty(value="For draft workflow schemes, this property is the issue type to workflow mappings for the original workflow scheme, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.")
    public Map<String, String> getOriginalIssueTypeMappings() {
        return this.originalIssueTypeMappings;
    }

    @ApiModelProperty(value="Whether the workflow scheme is a draft or not.")
    public Boolean getDraft() {
        return this.draft;
    }

    @ApiModelProperty(value="The user that last modified the draft workflow scheme. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.")
    public User getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    @ApiModelProperty(value="The date-time that the draft workflow scheme was last modified. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.")
    public String getLastModified() {
        return this.lastModified;
    }

    @ApiModelProperty(value="")
    public URI getSelf() {
        return this.self;
    }

    public WorkflowScheme updateDraftIfNeeded(Boolean updateDraftIfNeeded) {
        this.updateDraftIfNeeded = updateDraftIfNeeded;
        return this;
    }

    @ApiModelProperty(value="Whether to create or update a draft workflow scheme when updating an active workflow scheme. An active workflow scheme is a workflow scheme that is used by at least one project. The following examples show how this property works:   *  Update an active workflow scheme with `updateDraftIfNeeded` set to `true`: If a draft workflow scheme exists, it is updated. Otherwise, a draft workflow scheme is created.  *  Update an active workflow scheme with `updateDraftIfNeeded` set to `false`: An error is returned, as active workflow schemes cannot be updated.  *  Update an inactive workflow scheme with `updateDraftIfNeeded` set to `true`: The workflow scheme is updated, as inactive workflow schemes do not require drafts to update.  Defaults to `false`.")
    public Boolean getUpdateDraftIfNeeded() {
        return this.updateDraftIfNeeded;
    }

    public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
        this.updateDraftIfNeeded = updateDraftIfNeeded;
    }

    @ApiModelProperty(value="The issue types available in Jira.")
    public Map<String, IssueTypeDetails> getIssueTypes() {
        return this.issueTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowScheme workflowScheme = (WorkflowScheme)o;
        return Objects.equals(this.id, workflowScheme.id) && Objects.equals(this.name, workflowScheme.name) && Objects.equals(this.description, workflowScheme.description) && Objects.equals(this.defaultWorkflow, workflowScheme.defaultWorkflow) && Objects.equals(this.issueTypeMappings, workflowScheme.issueTypeMappings) && Objects.equals(this.originalDefaultWorkflow, workflowScheme.originalDefaultWorkflow) && Objects.equals(this.originalIssueTypeMappings, workflowScheme.originalIssueTypeMappings) && Objects.equals(this.draft, workflowScheme.draft) && Objects.equals(this.lastModifiedUser, workflowScheme.lastModifiedUser) && Objects.equals(this.lastModified, workflowScheme.lastModified) && Objects.equals(this.self, workflowScheme.self) && Objects.equals(this.updateDraftIfNeeded, workflowScheme.updateDraftIfNeeded) && Objects.equals(this.issueTypes, workflowScheme.issueTypes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.defaultWorkflow, this.issueTypeMappings, this.originalDefaultWorkflow, this.originalIssueTypeMappings, this.draft, this.lastModifiedUser, this.lastModified, this.self, this.updateDraftIfNeeded, this.issueTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowScheme {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    defaultWorkflow: ").append(this.toIndentedString(this.defaultWorkflow)).append("\n");
        sb.append("    issueTypeMappings: ").append(this.toIndentedString(this.issueTypeMappings)).append("\n");
        sb.append("    originalDefaultWorkflow: ").append(this.toIndentedString(this.originalDefaultWorkflow)).append("\n");
        sb.append("    originalIssueTypeMappings: ").append(this.toIndentedString(this.originalIssueTypeMappings)).append("\n");
        sb.append("    draft: ").append(this.toIndentedString(this.draft)).append("\n");
        sb.append("    lastModifiedUser: ").append(this.toIndentedString(this.lastModifiedUser)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    updateDraftIfNeeded: ").append(this.toIndentedString(this.updateDraftIfNeeded)).append("\n");
        sb.append("    issueTypes: ").append(this.toIndentedString(this.issueTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

