/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="Details about a task.")
public class TaskProgressBeanObject {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="result")
    private Object result = null;
    @JsonProperty(value="submittedBy")
    private Long submittedBy;
    @JsonProperty(value="progress")
    private Long progress;
    @JsonProperty(value="elapsedRuntime")
    private Long elapsedRuntime;
    @JsonProperty(value="submitted")
    private Long submitted;
    @JsonProperty(value="started")
    private Long started;
    @JsonProperty(value="finished")
    private Long finished;
    @JsonProperty(value="lastUpdate")
    private Long lastUpdate;

    public TaskProgressBeanObject self(URI self) {
        this.self = self;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL of the task.")
    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public TaskProgressBeanObject id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the task.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TaskProgressBeanObject description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the task.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaskProgressBeanObject status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the task.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TaskProgressBeanObject message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Information about the progress of the task.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TaskProgressBeanObject result(Object result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(value="The result of the task execution.")
    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public TaskProgressBeanObject submittedBy(Long submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the user who submitted the task.")
    public Long getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(Long submittedBy) {
        this.submittedBy = submittedBy;
    }

    public TaskProgressBeanObject progress(Long progress) {
        this.progress = progress;
        return this;
    }

    @ApiModelProperty(required=true, value="The progress of the task, as a percentage complete.")
    public Long getProgress() {
        return this.progress;
    }

    public void setProgress(Long progress) {
        this.progress = progress;
    }

    public TaskProgressBeanObject elapsedRuntime(Long elapsedRuntime) {
        this.elapsedRuntime = elapsedRuntime;
        return this;
    }

    @ApiModelProperty(required=true, value="The execution time of the task, in milliseconds.")
    public Long getElapsedRuntime() {
        return this.elapsedRuntime;
    }

    public void setElapsedRuntime(Long elapsedRuntime) {
        this.elapsedRuntime = elapsedRuntime;
    }

    public TaskProgressBeanObject submitted(Long submitted) {
        this.submitted = submitted;
        return this;
    }

    @ApiModelProperty(required=true, value="A timestamp recording when the task was submitted.")
    public Long getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Long submitted) {
        this.submitted = submitted;
    }

    public TaskProgressBeanObject started(Long started) {
        this.started = started;
        return this;
    }

    @ApiModelProperty(value="A timestamp recording when the task was started.")
    public Long getStarted() {
        return this.started;
    }

    public void setStarted(Long started) {
        this.started = started;
    }

    public TaskProgressBeanObject finished(Long finished) {
        this.finished = finished;
        return this;
    }

    @ApiModelProperty(value="A timestamp recording when the task was finished.")
    public Long getFinished() {
        return this.finished;
    }

    public void setFinished(Long finished) {
        this.finished = finished;
    }

    public TaskProgressBeanObject lastUpdate(Long lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @ApiModelProperty(required=true, value="A timestamp recording when the task progress was last updated.")
    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskProgressBeanObject taskProgressBeanObject = (TaskProgressBeanObject)o;
        return Objects.equals(this.self, taskProgressBeanObject.self) && Objects.equals(this.id, taskProgressBeanObject.id) && Objects.equals(this.description, taskProgressBeanObject.description) && Objects.equals((Object)this.status, (Object)taskProgressBeanObject.status) && Objects.equals(this.message, taskProgressBeanObject.message) && Objects.equals(this.result, taskProgressBeanObject.result) && Objects.equals(this.submittedBy, taskProgressBeanObject.submittedBy) && Objects.equals(this.progress, taskProgressBeanObject.progress) && Objects.equals(this.elapsedRuntime, taskProgressBeanObject.elapsedRuntime) && Objects.equals(this.submitted, taskProgressBeanObject.submitted) && Objects.equals(this.started, taskProgressBeanObject.started) && Objects.equals(this.finished, taskProgressBeanObject.finished) && Objects.equals(this.lastUpdate, taskProgressBeanObject.lastUpdate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.self, this.id, this.description, this.status, this.message, this.result, this.submittedBy, this.progress, this.elapsedRuntime, this.submitted, this.started, this.finished, this.lastUpdate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskProgressBeanObject {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    submittedBy: ").append(this.toIndentedString(this.submittedBy)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    elapsedRuntime: ").append(this.toIndentedString(this.elapsedRuntime)).append("\n");
        sb.append("    submitted: ").append(this.toIndentedString(this.submitted)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ENQUEUED("ENQUEUED"),
        RUNNING("RUNNING"),
        COMPLETE("COMPLETE"),
        FAILED("FAILED"),
        CANCEL_REQUESTED("CANCEL_REQUESTED"),
        CANCELLED("CANCELLED"),
        DEAD("DEAD");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

