/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.RenamedCascadingOption;

@ApiModel(description="Details of a custom field option to rename.")
public class RenamedOption {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="newValue")
    private String newValue;
    @JsonProperty(value="cascadingOptions")
    private List<RenamedCascadingOption> cascadingOptions = new ArrayList<RenamedCascadingOption>();

    public RenamedOption value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The current option value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RenamedOption newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    @ApiModelProperty(required=true, value="The new value of the option.")
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public RenamedOption cascadingOptions(List<RenamedCascadingOption> cascadingOptions) {
        this.cascadingOptions = cascadingOptions;
        return this;
    }

    public RenamedOption addCascadingOptionsItem(RenamedCascadingOption cascadingOptionsItem) {
        if (this.cascadingOptions == null) {
            this.cascadingOptions = new ArrayList<RenamedCascadingOption>();
        }
        this.cascadingOptions.add(cascadingOptionsItem);
        return this;
    }

    @ApiModelProperty(value="The new values for the cascading options of this option. Only used for Select List (cascading) fields.")
    public List<RenamedCascadingOption> getCascadingOptions() {
        return this.cascadingOptions;
    }

    public void setCascadingOptions(List<RenamedCascadingOption> cascadingOptions) {
        this.cascadingOptions = cascadingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenamedOption renamedOption = (RenamedOption)o;
        return Objects.equals(this.value, renamedOption.value) && Objects.equals(this.newValue, renamedOption.newValue) && Objects.equals(this.cascadingOptions, renamedOption.cascadingOptions);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.newValue, this.cascadingOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RenamedOption {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.newValue)).append("\n");
        sb.append("    cascadingOptions: ").append(this.toIndentedString(this.cascadingOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

