/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProjectScopeBean {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="attributes")
    private List<AttributesEnum> attributes = new ArrayList<AttributesEnum>();

    public ProjectScopeBean id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the project that the option's behavior applies to.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProjectScopeBean attributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ProjectScopeBean addAttributesItem(AttributesEnum attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributesEnum>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="Defines the behavior of the option in the project.If notSelectable is set, the option cannot be set as the field's value. This is useful for archiving an option that has previously been selected but shouldn't be used anymore.If defaultValue is set, the option is selected by default.")
    public List<AttributesEnum> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectScopeBean projectScopeBean = (ProjectScopeBean)o;
        return Objects.equals(this.id, projectScopeBean.id) && Objects.equals(this.attributes, projectScopeBean.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectScopeBean {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AttributesEnum {
        NOTSELECTABLE("notSelectable"),
        DEFAULTVALUE("defaultValue");

        private String value;

        private AttributesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AttributesEnum fromValue(String value) {
            for (AttributesEnum b : AttributesEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

