/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.AvatarUrlsBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeIssueCreateMetadata;

@ApiModel(description="Details of the issue creation metadata for a project.")
public class ProjectIssueCreateMetadata {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="avatarUrls")
    private AvatarUrlsBean avatarUrls;
    @JsonProperty(value="issuetypes")
    private List<IssueTypeIssueCreateMetadata> issuetypes = new ArrayList<IssueTypeIssueCreateMetadata>();

    @ApiModelProperty(value="Expand options that include additional project issue create metadata details in the response.")
    public String getExpand() {
        return this.expand;
    }

    @ApiModelProperty(value="The URL of the project.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The ID of the project.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The key of the project.")
    public String getKey() {
        return this.key;
    }

    @ApiModelProperty(value="The name of the project.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="List of the project's avatars, returning the avatar size and associated URL.")
    public AvatarUrlsBean getAvatarUrls() {
        return this.avatarUrls;
    }

    @ApiModelProperty(value="List of the issue types supported by the project.")
    public List<IssueTypeIssueCreateMetadata> getIssuetypes() {
        return this.issuetypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectIssueCreateMetadata projectIssueCreateMetadata = (ProjectIssueCreateMetadata)o;
        return Objects.equals(this.expand, projectIssueCreateMetadata.expand) && Objects.equals(this.self, projectIssueCreateMetadata.self) && Objects.equals(this.id, projectIssueCreateMetadata.id) && Objects.equals(this.key, projectIssueCreateMetadata.key) && Objects.equals(this.name, projectIssueCreateMetadata.name) && Objects.equals(this.avatarUrls, projectIssueCreateMetadata.avatarUrls) && Objects.equals(this.issuetypes, projectIssueCreateMetadata.issuetypes);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.self, this.id, this.key, this.name, this.avatarUrls, this.issuetypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectIssueCreateMetadata {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    avatarUrls: ").append(this.toIndentedString(this.avatarUrls)).append("\n");
        sb.append("    issuetypes: ").append(this.toIndentedString(this.issuetypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

