/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserDetails;

@ApiModel(description="A paged list. To access additional details append `[start-index:end-index]` to the expand request. For example, `?expand=sharedUsers[10:40]` returns a list starting at item 10 and finishing at item 40.")
public class PagedListUserDetailsApplicationUser {
    @JsonProperty(value="size")
    private Integer size;
    @JsonProperty(value="items")
    private List<UserDetails> items = new ArrayList<UserDetails>();
    @JsonProperty(value="max-results")
    private Integer maxResults;
    @JsonProperty(value="start-index")
    private Integer startIndex;
    @JsonProperty(value="end-index")
    private Integer endIndex;

    @ApiModelProperty(value="The number of items on the page.")
    public Integer getSize() {
        return this.size;
    }

    @ApiModelProperty(value="The list of items.")
    public List<UserDetails> getItems() {
        return this.items;
    }

    @ApiModelProperty(value="The maximum number of results that could be on the page.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @ApiModelProperty(value="The index of the first item returned on the page.")
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @ApiModelProperty(value="The index of the last item returned on the page.")
    public Integer getEndIndex() {
        return this.endIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedListUserDetailsApplicationUser pagedListUserDetailsApplicationUser = (PagedListUserDetailsApplicationUser)o;
        return Objects.equals(this.size, pagedListUserDetailsApplicationUser.size) && Objects.equals(this.items, pagedListUserDetailsApplicationUser.items) && Objects.equals(this.maxResults, pagedListUserDetailsApplicationUser.maxResults) && Objects.equals(this.startIndex, pagedListUserDetailsApplicationUser.startIndex) && Objects.equals(this.endIndex, pagedListUserDetailsApplicationUser.endIndex);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.items, this.maxResults, this.startIndex, this.endIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PagedListUserDetailsApplicationUser {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    endIndex: ").append(this.toIndentedString(this.endIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

