/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JiraExpressionEvaluationMetaDataBean;

@ApiModel(description="The result of evaluating a Jira expression.")
public class JiraExpressionResult {
    @JsonProperty(value="value")
    private Object value = null;
    @JsonProperty(value="meta")
    private JiraExpressionEvaluationMetaDataBean meta;

    public JiraExpressionResult value(Object value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the evaluated expression. It may be a primitive JSON value or a Jira REST API object. (Some expressions do not produce any meaningful results\u2014for example, an expression that returns a lambda function\u2014if that's the case a simple string representation is returned. These string representations should not be relied upon and may change without notice.)")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public JiraExpressionResult meta(JiraExpressionEvaluationMetaDataBean meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(value="Contains various characteristics of the performed expression evaluation.")
    public JiraExpressionEvaluationMetaDataBean getMeta() {
        return this.meta;
    }

    public void setMeta(JiraExpressionEvaluationMetaDataBean meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionResult jiraExpressionResult = (JiraExpressionResult)o;
        return Objects.equals(this.value, jiraExpressionResult.value) && Objects.equals(this.meta, jiraExpressionResult.meta);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionResult {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

