/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IdOrKeyBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.JexpIssues;

public class JiraExpressionEvalContextBean {
    @JsonProperty(value="issue")
    private IdOrKeyBean issue;
    @JsonProperty(value="issues")
    private JexpIssues issues;
    @JsonProperty(value="project")
    private IdOrKeyBean project;
    @JsonProperty(value="sprint")
    private Long sprint;
    @JsonProperty(value="board")
    private Long board;
    @JsonProperty(value="serviceDesk")
    private Long serviceDesk;
    @JsonProperty(value="customerRequest")
    private Long customerRequest;

    public JiraExpressionEvalContextBean issue(IdOrKeyBean issue) {
        this.issue = issue;
        return this;
    }

    @ApiModelProperty(value="The issue that is available under the `issue` variable when evaluating the expression.")
    public IdOrKeyBean getIssue() {
        return this.issue;
    }

    public void setIssue(IdOrKeyBean issue) {
        this.issue = issue;
    }

    public JiraExpressionEvalContextBean issues(JexpIssues issues) {
        this.issues = issues;
        return this;
    }

    @ApiModelProperty(value="The collection of issues that is available under the `issues` variable when evaluating the expression.")
    public JexpIssues getIssues() {
        return this.issues;
    }

    public void setIssues(JexpIssues issues) {
        this.issues = issues;
    }

    public JiraExpressionEvalContextBean project(IdOrKeyBean project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(value="The project that is available under the `project` variable when evaluating the expression.")
    public IdOrKeyBean getProject() {
        return this.project;
    }

    public void setProject(IdOrKeyBean project) {
        this.project = project;
    }

    public JiraExpressionEvalContextBean sprint(Long sprint) {
        this.sprint = sprint;
        return this;
    }

    @ApiModelProperty(value="The ID of the sprint that is available under the `sprint` variable when evaluating the expression.")
    public Long getSprint() {
        return this.sprint;
    }

    public void setSprint(Long sprint) {
        this.sprint = sprint;
    }

    public JiraExpressionEvalContextBean board(Long board) {
        this.board = board;
        return this;
    }

    @ApiModelProperty(value="The ID of the board that is available under the `board` variable when evaluating the expression.")
    public Long getBoard() {
        return this.board;
    }

    public void setBoard(Long board) {
        this.board = board;
    }

    public JiraExpressionEvalContextBean serviceDesk(Long serviceDesk) {
        this.serviceDesk = serviceDesk;
        return this;
    }

    @ApiModelProperty(value="The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.")
    public Long getServiceDesk() {
        return this.serviceDesk;
    }

    public void setServiceDesk(Long serviceDesk) {
        this.serviceDesk = serviceDesk;
    }

    public JiraExpressionEvalContextBean customerRequest(Long customerRequest) {
        this.customerRequest = customerRequest;
        return this;
    }

    @ApiModelProperty(value="The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.")
    public Long getCustomerRequest() {
        return this.customerRequest;
    }

    public void setCustomerRequest(Long customerRequest) {
        this.customerRequest = customerRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionEvalContextBean jiraExpressionEvalContextBean = (JiraExpressionEvalContextBean)o;
        return Objects.equals(this.issue, jiraExpressionEvalContextBean.issue) && Objects.equals(this.issues, jiraExpressionEvalContextBean.issues) && Objects.equals(this.project, jiraExpressionEvalContextBean.project) && Objects.equals(this.sprint, jiraExpressionEvalContextBean.sprint) && Objects.equals(this.board, jiraExpressionEvalContextBean.board) && Objects.equals(this.serviceDesk, jiraExpressionEvalContextBean.serviceDesk) && Objects.equals(this.customerRequest, jiraExpressionEvalContextBean.customerRequest);
    }

    public int hashCode() {
        return Objects.hash(this.issue, this.issues, this.project, this.sprint, this.board, this.serviceDesk, this.customerRequest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionEvalContextBean {\n");
        sb.append("    issue: ").append(this.toIndentedString(this.issue)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    sprint: ").append(this.toIndentedString(this.sprint)).append("\n");
        sb.append("    board: ").append(this.toIndentedString(this.board)).append("\n");
        sb.append("    serviceDesk: ").append(this.toIndentedString(this.serviceDesk)).append("\n");
        sb.append("    customerRequest: ").append(this.toIndentedString(this.customerRequest)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

