/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JiraExpressionComplexity;
import org.everit.atlassian.restclient.jiracloud.v3.model.JiraExpressionValidationError;

@ApiModel(description="Details about the analysed Jira expression.")
public class JiraExpressionAnalysis {
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="errors")
    private List<JiraExpressionValidationError> errors = new ArrayList<JiraExpressionValidationError>();
    @JsonProperty(value="valid")
    private Boolean valid;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="complexity")
    private JiraExpressionComplexity complexity;

    public JiraExpressionAnalysis expression(String expression) {
        this.expression = expression;
        return this;
    }

    @ApiModelProperty(required=true, value="The analysed expression.")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public JiraExpressionAnalysis errors(List<JiraExpressionValidationError> errors) {
        this.errors = errors;
        return this;
    }

    public JiraExpressionAnalysis addErrorsItem(JiraExpressionValidationError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<JiraExpressionValidationError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="A list of validation errors. Not included if the expression is valid.")
    public List<JiraExpressionValidationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<JiraExpressionValidationError> errors) {
        this.errors = errors;
    }

    public JiraExpressionAnalysis valid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the expression is valid and the interpreter will evaluate it. Note that the expression may fail at runtime (for example, if it executes too many expensive operations).")
    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public JiraExpressionAnalysis type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="EXPERIMENTAL. The inferred type of the expression.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JiraExpressionAnalysis complexity(JiraExpressionComplexity complexity) {
        this.complexity = complexity;
        return this;
    }

    @ApiModelProperty(value="")
    public JiraExpressionComplexity getComplexity() {
        return this.complexity;
    }

    public void setComplexity(JiraExpressionComplexity complexity) {
        this.complexity = complexity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionAnalysis jiraExpressionAnalysis = (JiraExpressionAnalysis)o;
        return Objects.equals(this.expression, jiraExpressionAnalysis.expression) && Objects.equals(this.errors, jiraExpressionAnalysis.errors) && Objects.equals(this.valid, jiraExpressionAnalysis.valid) && Objects.equals(this.type, jiraExpressionAnalysis.type) && Objects.equals(this.complexity, jiraExpressionAnalysis.complexity);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.errors, this.valid, this.type, this.complexity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionAnalysis {\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    valid: ").append(this.toIndentedString(this.valid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    complexity: ").append(this.toIndentedString(this.complexity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

