/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of functions that can be used in advanced searches.")
public class FunctionReferenceData {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="isList")
    private IsListEnum isList;
    @JsonProperty(value="types")
    private List<String> types = new ArrayList<String>();

    public FunctionReferenceData value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The function identifier.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FunctionReferenceData displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The display name of the function.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public FunctionReferenceData isList(IsListEnum isList) {
        this.isList = isList;
        return this;
    }

    @ApiModelProperty(value="Whether the function can take a list of arguments.")
    public IsListEnum getIsList() {
        return this.isList;
    }

    public void setIsList(IsListEnum isList) {
        this.isList = isList;
    }

    public FunctionReferenceData types(List<String> types) {
        this.types = types;
        return this;
    }

    public FunctionReferenceData addTypesItem(String typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="The data types returned by the function.")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionReferenceData functionReferenceData = (FunctionReferenceData)o;
        return Objects.equals(this.value, functionReferenceData.value) && Objects.equals(this.displayName, functionReferenceData.displayName) && Objects.equals((Object)this.isList, (Object)functionReferenceData.isList) && Objects.equals(this.types, functionReferenceData.types);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.displayName, this.isList, this.types});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionReferenceData {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    isList: ").append(this.toIndentedString((Object)this.isList)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IsListEnum {
        TRUE("true"),
        FALSE("false");

        private String value;

        private IsListEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IsListEnum fromValue(String value) {
            for (IsListEnum b : IsListEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

