/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An operand that is a function. See [Advanced searching - functions reference](https://confluence.atlassian.com/x/dwiiLQ) for more information about JQL functions.")
public class FunctionOperand {
    @JsonProperty(value="function")
    private String function;
    @JsonProperty(value="arguments")
    private List<String> arguments = new ArrayList<String>();

    public FunctionOperand function(String function) {
        this.function = function;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the function.")
    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public FunctionOperand arguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public FunctionOperand addArgumentsItem(String argumentsItem) {
        this.arguments.add(argumentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of function arguments.")
    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionOperand functionOperand = (FunctionOperand)o;
        return Objects.equals(this.function, functionOperand.function) && Objects.equals(this.arguments, functionOperand.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.arguments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionOperand {\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

