/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A list of issue IDs and the value to update a custom field to.")
public class CustomFieldValueUpdate {
    @JsonProperty(value="issueIds")
    private List<Long> issueIds = new ArrayList<Long>();
    @JsonProperty(value="value")
    private Object value = null;

    public CustomFieldValueUpdate issueIds(List<Long> issueIds) {
        this.issueIds = issueIds;
        return this;
    }

    public CustomFieldValueUpdate addIssueIdsItem(Long issueIdsItem) {
        this.issueIds.add(issueIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of issue IDs.")
    public List<Long> getIssueIds() {
        return this.issueIds;
    }

    public void setIssueIds(List<Long> issueIds) {
        this.issueIds = issueIds;
    }

    public CustomFieldValueUpdate value(Object value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#data-types) as follows:   *  `string` \u2013 the value must be a string.  *  `number` \u2013 the value must be a number.  *  `datetime` \u2013 the value must be a string that represents a date in the ISO format, for example `\"2021-01-18T12:00:00-03:00\"`.  *  `user` \u2013 the value must be an object that contains the `accountId` field.  *  `group` \u2013 the value must be an object that contains the group `name` field.  A list of appropriate values must be provided if the field is of the `list` [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#collection-types).")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldValueUpdate customFieldValueUpdate = (CustomFieldValueUpdate)o;
        return Objects.equals(this.issueIds, customFieldValueUpdate.issueIds) && Objects.equals(this.value, customFieldValueUpdate.value);
    }

    public int hashCode() {
        return Objects.hash(this.issueIds, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomFieldValueUpdate {\n");
        sb.append("    issueIds: ").append(this.toIndentedString(this.issueIds)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

