/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.CreateWorkflowTransitionRulesDetails;

@ApiModel(description="The details of a workflow transition.")
public class CreateWorkflowTransitionDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="from")
    private List<String> from = new ArrayList<String>();
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="rules")
    private CreateWorkflowTransitionRulesDetails rules;

    public CreateWorkflowTransitionDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the transition. The maximum length is 60 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateWorkflowTransitionDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the transition. The maximum length is 1000 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWorkflowTransitionDetails from(List<String> from) {
        this.from = from;
        return this;
    }

    public CreateWorkflowTransitionDetails addFromItem(String fromItem) {
        if (this.from == null) {
            this.from = new ArrayList<String>();
        }
        this.from.add(fromItem);
        return this;
    }

    @ApiModelProperty(value="The statuses the transition can start from.")
    public List<String> getFrom() {
        return this.from;
    }

    public void setFrom(List<String> from) {
        this.from = from;
    }

    public CreateWorkflowTransitionDetails to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(required=true, value="The status the transition goes to.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public CreateWorkflowTransitionDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the transition.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateWorkflowTransitionDetails rules(CreateWorkflowTransitionRulesDetails rules) {
        this.rules = rules;
        return this;
    }

    @ApiModelProperty(value="The rules of the transition.")
    public CreateWorkflowTransitionRulesDetails getRules() {
        return this.rules;
    }

    public void setRules(CreateWorkflowTransitionRulesDetails rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkflowTransitionDetails createWorkflowTransitionDetails = (CreateWorkflowTransitionDetails)o;
        return Objects.equals(this.name, createWorkflowTransitionDetails.name) && Objects.equals(this.description, createWorkflowTransitionDetails.description) && Objects.equals(this.from, createWorkflowTransitionDetails.from) && Objects.equals(this.to, createWorkflowTransitionDetails.to) && Objects.equals((Object)this.type, (Object)createWorkflowTransitionDetails.type) && Objects.equals(this.rules, createWorkflowTransitionDetails.rules);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.from, this.to, this.type, this.rules});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkflowTransitionDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GLOBAL("global"),
        INITIAL("initial"),
        DIRECTED("directed");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

