/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.CreateWorkflowStatusDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.CreateWorkflowTransitionDetails;

@ApiModel(description="The details of a workflow.")
public class CreateWorkflowDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="transitions")
    private List<CreateWorkflowTransitionDetails> transitions = new ArrayList<CreateWorkflowTransitionDetails>();
    @JsonProperty(value="statuses")
    private List<CreateWorkflowStatusDetails> statuses = new ArrayList<CreateWorkflowStatusDetails>();

    public CreateWorkflowDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the workflow. The name must be unique. The maximum length is 255 characters. Characters can be separated by a whitespace but the name cannot start or end with a whitespace.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateWorkflowDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the workflow. The maximum length is 1000 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWorkflowDetails transitions(List<CreateWorkflowTransitionDetails> transitions) {
        this.transitions = transitions;
        return this;
    }

    public CreateWorkflowDetails addTransitionsItem(CreateWorkflowTransitionDetails transitionsItem) {
        this.transitions.add(transitionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The transitions of the workflow. For the request to be valid, these transitions must:   *  include one *initial* transition.  *  not use the same name for a *global* and *directed* transition.  *  have a unique name for each *global* transition.  *  have a unique 'to' status for each *global* transition.  *  have unique names for each transition from a status.  *  not have a 'from' status on *initial* and *global* transitions.  *  have a 'from' status on *directed* transitions.  All the transition statuses must be included in `statuses`.")
    public List<CreateWorkflowTransitionDetails> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<CreateWorkflowTransitionDetails> transitions) {
        this.transitions = transitions;
    }

    public CreateWorkflowDetails statuses(List<CreateWorkflowStatusDetails> statuses) {
        this.statuses = statuses;
        return this;
    }

    public CreateWorkflowDetails addStatusesItem(CreateWorkflowStatusDetails statusesItem) {
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The statuses of the workflow. Any status that does not include a transition is added to the workflow without a transition.")
    public List<CreateWorkflowStatusDetails> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<CreateWorkflowStatusDetails> statuses) {
        this.statuses = statuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkflowDetails createWorkflowDetails = (CreateWorkflowDetails)o;
        return Objects.equals(this.name, createWorkflowDetails.name) && Objects.equals(this.description, createWorkflowDetails.description) && Objects.equals(this.transitions, createWorkflowDetails.transitions) && Objects.equals(this.statuses, createWorkflowDetails.statuses);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.transitions, this.statuses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkflowDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

