/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueFilterForBulkPropertySet;

@ApiModel(description="Bulk issue property update request details.")
public class BulkIssuePropertyUpdateRequest {
    @JsonProperty(value="value")
    private Object value = null;
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="filter")
    private IssueFilterForBulkPropertySet filter;

    public BulkIssuePropertyUpdateRequest value(Object value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value of the property. The value must be a [valid](https://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public BulkIssuePropertyUpdateRequest expression(String expression) {
        this.expression = expression;
        return this;
    }

    @ApiModelProperty(value="EXPERIMENTAL. The Jira expression to calculate the value of the property. The value of the expression must be an object that can be converted to JSON, such as a number, boolean, string, list, or map. The context variables available to the expression are `issue` and `user`. Issues for which the expression returns a value whose JSON representation is longer than 32768 characters are ignored.")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public BulkIssuePropertyUpdateRequest filter(IssueFilterForBulkPropertySet filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(value="The bulk operation filter.")
    public IssueFilterForBulkPropertySet getFilter() {
        return this.filter;
    }

    public void setFilter(IssueFilterForBulkPropertySet filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkIssuePropertyUpdateRequest bulkIssuePropertyUpdateRequest = (BulkIssuePropertyUpdateRequest)o;
        return Objects.equals(this.value, bulkIssuePropertyUpdateRequest.value) && Objects.equals(this.expression, bulkIssuePropertyUpdateRequest.expression) && Objects.equals(this.filter, bulkIssuePropertyUpdateRequest.filter);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.expression, this.filter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkIssuePropertyUpdateRequest {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

