/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of an application role.")
public class ApplicationRole {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="groups")
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="defaultGroups")
    private List<String> defaultGroups = new ArrayList<String>();
    @JsonProperty(value="selectedByDefault")
    private Boolean selectedByDefault;
    @JsonProperty(value="defined")
    private Boolean defined;
    @JsonProperty(value="numberOfSeats")
    private Integer numberOfSeats;
    @JsonProperty(value="remainingSeats")
    private Integer remainingSeats;
    @JsonProperty(value="userCount")
    private Integer userCount;
    @JsonProperty(value="userCountDescription")
    private String userCountDescription;
    @JsonProperty(value="hasUnlimitedSeats")
    private Boolean hasUnlimitedSeats;
    @JsonProperty(value="platform")
    private Boolean platform;

    public ApplicationRole key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The key of the application role.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ApplicationRole groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public ApplicationRole addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="The groups associated with the application role.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public ApplicationRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The display name of the application role.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationRole defaultGroups(List<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
        return this;
    }

    public ApplicationRole addDefaultGroupsItem(String defaultGroupsItem) {
        if (this.defaultGroups == null) {
            this.defaultGroups = new ArrayList<String>();
        }
        this.defaultGroups.add(defaultGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The groups that are granted default access for this application role.")
    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public void setDefaultGroups(List<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public ApplicationRole selectedByDefault(Boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
        return this;
    }

    @ApiModelProperty(value="Determines whether this application role should be selected by default on user creation.")
    public Boolean getSelectedByDefault() {
        return this.selectedByDefault;
    }

    public void setSelectedByDefault(Boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
    }

    public ApplicationRole defined(Boolean defined) {
        this.defined = defined;
        return this;
    }

    @ApiModelProperty(value="Deprecated.")
    public Boolean getDefined() {
        return this.defined;
    }

    public void setDefined(Boolean defined) {
        this.defined = defined;
    }

    public ApplicationRole numberOfSeats(Integer numberOfSeats) {
        this.numberOfSeats = numberOfSeats;
        return this;
    }

    @ApiModelProperty(value="The maximum count of users on your license.")
    public Integer getNumberOfSeats() {
        return this.numberOfSeats;
    }

    public void setNumberOfSeats(Integer numberOfSeats) {
        this.numberOfSeats = numberOfSeats;
    }

    public ApplicationRole remainingSeats(Integer remainingSeats) {
        this.remainingSeats = remainingSeats;
        return this;
    }

    @ApiModelProperty(value="The count of users remaining on your license.")
    public Integer getRemainingSeats() {
        return this.remainingSeats;
    }

    public void setRemainingSeats(Integer remainingSeats) {
        this.remainingSeats = remainingSeats;
    }

    public ApplicationRole userCount(Integer userCount) {
        this.userCount = userCount;
        return this;
    }

    @ApiModelProperty(value="The number of users counting against your license.")
    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public ApplicationRole userCountDescription(String userCountDescription) {
        this.userCountDescription = userCountDescription;
        return this;
    }

    @ApiModelProperty(value="The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.")
    public String getUserCountDescription() {
        return this.userCountDescription;
    }

    public void setUserCountDescription(String userCountDescription) {
        this.userCountDescription = userCountDescription;
    }

    public ApplicationRole hasUnlimitedSeats(Boolean hasUnlimitedSeats) {
        this.hasUnlimitedSeats = hasUnlimitedSeats;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getHasUnlimitedSeats() {
        return this.hasUnlimitedSeats;
    }

    public void setHasUnlimitedSeats(Boolean hasUnlimitedSeats) {
        this.hasUnlimitedSeats = hasUnlimitedSeats;
    }

    public ApplicationRole platform(Boolean platform) {
        this.platform = platform;
        return this;
    }

    @ApiModelProperty(value="Indicates if the application role belongs to Jira platform (`jira-core`).")
    public Boolean getPlatform() {
        return this.platform;
    }

    public void setPlatform(Boolean platform) {
        this.platform = platform;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRole applicationRole = (ApplicationRole)o;
        return Objects.equals(this.key, applicationRole.key) && Objects.equals(this.groups, applicationRole.groups) && Objects.equals(this.name, applicationRole.name) && Objects.equals(this.defaultGroups, applicationRole.defaultGroups) && Objects.equals(this.selectedByDefault, applicationRole.selectedByDefault) && Objects.equals(this.defined, applicationRole.defined) && Objects.equals(this.numberOfSeats, applicationRole.numberOfSeats) && Objects.equals(this.remainingSeats, applicationRole.remainingSeats) && Objects.equals(this.userCount, applicationRole.userCount) && Objects.equals(this.userCountDescription, applicationRole.userCountDescription) && Objects.equals(this.hasUnlimitedSeats, applicationRole.hasUnlimitedSeats) && Objects.equals(this.platform, applicationRole.platform);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.groups, this.name, this.defaultGroups, this.selectedByDefault, this.defined, this.numberOfSeats, this.remainingSeats, this.userCount, this.userCountDescription, this.hasUnlimitedSeats, this.platform);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationRole {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    defaultGroups: ").append(this.toIndentedString(this.defaultGroups)).append("\n");
        sb.append("    selectedByDefault: ").append(this.toIndentedString(this.selectedByDefault)).append("\n");
        sb.append("    defined: ").append(this.toIndentedString(this.defined)).append("\n");
        sb.append("    numberOfSeats: ").append(this.toIndentedString(this.numberOfSeats)).append("\n");
        sb.append("    remainingSeats: ").append(this.toIndentedString(this.remainingSeats)).append("\n");
        sb.append("    userCount: ").append(this.toIndentedString(this.userCount)).append("\n");
        sb.append("    userCountDescription: ").append(this.toIndentedString(this.userCountDescription)).append("\n");
        sb.append("    hasUnlimitedSeats: ").append(this.toIndentedString(this.hasUnlimitedSeats)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

