/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of an application property.")
public class ApplicationProperty {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="desc")
    private String desc;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="defaultValue")
    private String defaultValue;
    @JsonProperty(value="example")
    private String example;
    @JsonProperty(value="allowedValues")
    private List<String> allowedValues = new ArrayList<String>();

    public ApplicationProperty id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the application property. The ID and key are the same.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApplicationProperty key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The key of the application property. The ID and key are the same.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ApplicationProperty value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The new value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ApplicationProperty name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the application property.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationProperty desc(String desc) {
        this.desc = desc;
        return this;
    }

    @ApiModelProperty(value="The description of the application property.")
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public ApplicationProperty type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The data type of the application property.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApplicationProperty defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @ApiModelProperty(value="The default value of the application property.")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ApplicationProperty example(String example) {
        this.example = example;
        return this;
    }

    @ApiModelProperty(value="")
    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public ApplicationProperty allowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }

    public ApplicationProperty addAllowedValuesItem(String allowedValuesItem) {
        if (this.allowedValues == null) {
            this.allowedValues = new ArrayList<String>();
        }
        this.allowedValues.add(allowedValuesItem);
        return this;
    }

    @ApiModelProperty(value="The allowed values, if applicable.")
    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationProperty applicationProperty = (ApplicationProperty)o;
        return Objects.equals(this.id, applicationProperty.id) && Objects.equals(this.key, applicationProperty.key) && Objects.equals(this.value, applicationProperty.value) && Objects.equals(this.name, applicationProperty.name) && Objects.equals(this.desc, applicationProperty.desc) && Objects.equals(this.type, applicationProperty.type) && Objects.equals(this.defaultValue, applicationProperty.defaultValue) && Objects.equals(this.example, applicationProperty.example) && Objects.equals(this.allowedValues, applicationProperty.allowedValues);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.value, this.name, this.desc, this.type, this.defaultValue, this.example, this.allowedValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationProperty {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    desc: ").append(this.toIndentedString(this.desc)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    example: ").append(this.toIndentedString(this.example)).append("\n");
        sb.append("    allowedValues: ").append(this.toIndentedString(this.allowedValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

