/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.ScreenableTab;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ScreenTabsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<ScreenableTab> returnType_addScreenTab = new TypeReference<ScreenableTab>(){};
    private static final TypeReference<List<ScreenableTab>> returnType_getAllScreenTabs = new TypeReference<List<ScreenableTab>>(){};
    private static final TypeReference<Object> returnType_moveScreenTab = new TypeReference<Object>(){};
    private static final TypeReference<ScreenableTab> returnType_renameScreenTab = new TypeReference<ScreenableTab>(){};
    private final RestClient restClient;

    public ScreenTabsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ScreenableTab> addScreenTab(Long screenId, ScreenableTab screenableTab, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/screens/{screenId}/tabs");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(screenableTab));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addScreenTab);
    }

    public Completable deleteScreenTab(Long screenId, Long tabId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/screens/{screenId}/tabs/{tabId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<List<ScreenableTab>> getAllScreenTabs(Long screenId, Optional<String> projectKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/screens/{screenId}/tabs");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllScreenTabs);
    }

    public Single<Object> moveScreenTab(Long screenId, Long tabId, Integer pos, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/screens/{screenId}/tabs/{tabId}/move/{pos}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        pathParams.put("pos", String.valueOf(pos));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_moveScreenTab);
    }

    public Single<ScreenableTab> renameScreenTab(Long screenId, Long tabId, ScreenableTab screenableTab, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/screens/{screenId}/tabs/{tabId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(screenableTab));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_renameScreenTab);
    }
}

