/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectType;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectTypeApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<ProjectType> returnType_getAccessibleProjectTypeByKey = new TypeReference<ProjectType>(){};
    private static final TypeReference<List<ProjectType>> returnType_getAllProjectTypes = new TypeReference<List<ProjectType>>(){};
    private static final TypeReference<ProjectType> returnType_getProjectTypeByKey = new TypeReference<ProjectType>(){};
    private final RestClient restClient;

    public ProjectTypeApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ProjectType> getAccessibleProjectTypeByKey(String projectTypeKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/type/{projectTypeKey}/accessible");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectTypeKey", String.valueOf(projectTypeKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAccessibleProjectTypeByKey);
    }

    public Single<List<ProjectType>> getAllProjectTypes(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/type");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllProjectTypes);
    }

    public Single<ProjectType> getProjectTypeByKey(String projectTypeKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/type/{projectTypeKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectTypeKey", String.valueOf(projectTypeKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectTypeByKey);
    }
}

