/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeIDs;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeSchemeDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeSchemeID;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeSchemeProjectAssociation;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeSchemeUpdateDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.OrderOfIssueTypes;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanIssueTypeScheme;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanIssueTypeSchemeMapping;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanIssueTypeSchemeProjects;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueTypeSchemesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_addIssueTypesToIssueTypeScheme = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_assignIssueTypeSchemeToProject = new TypeReference<Object>(){};
    private static final TypeReference<IssueTypeSchemeID> returnType_createIssueTypeScheme = new TypeReference<IssueTypeSchemeID>(){};
    private static final TypeReference<Object> returnType_deleteIssueTypeScheme = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanIssueTypeScheme> returnType_getAllIssueTypeSchemes = new TypeReference<PageBeanIssueTypeScheme>(){};
    private static final TypeReference<PageBeanIssueTypeSchemeProjects> returnType_getIssueTypeSchemeForProjects = new TypeReference<PageBeanIssueTypeSchemeProjects>(){};
    private static final TypeReference<PageBeanIssueTypeSchemeMapping> returnType_getIssueTypeSchemesMapping = new TypeReference<PageBeanIssueTypeSchemeMapping>(){};
    private static final TypeReference<Object> returnType_removeIssueTypeFromIssueTypeScheme = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_reorderIssueTypesInIssueTypeScheme = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateIssueTypeScheme = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueTypeSchemesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addIssueTypesToIssueTypeScheme(Long issueTypeSchemeId, IssueTypeIDs issueTypeIDs, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/{issueTypeSchemeId}/issuetype");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueTypeSchemeId", String.valueOf(issueTypeSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeIDs));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addIssueTypesToIssueTypeScheme);
    }

    public Single<Object> assignIssueTypeSchemeToProject(IssueTypeSchemeProjectAssociation issueTypeSchemeProjectAssociation, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeSchemeProjectAssociation));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignIssueTypeSchemeToProject);
    }

    public Single<IssueTypeSchemeID> createIssueTypeScheme(IssueTypeSchemeDetails issueTypeSchemeDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeSchemeDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueTypeScheme);
    }

    public Single<Object> deleteIssueTypeScheme(Long issueTypeSchemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/{issueTypeSchemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueTypeSchemeId", String.valueOf(issueTypeSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteIssueTypeScheme);
    }

    public Single<PageBeanIssueTypeScheme> getAllIssueTypeSchemes(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllIssueTypeSchemes);
    }

    public Single<PageBeanIssueTypeSchemeProjects> getIssueTypeSchemeForProjects(List<Long> projectId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        queryParams.put("projectId", RestClientUtil.objectCollectionToStringCollection(projectId));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueTypeSchemeForProjects);
    }

    public Single<PageBeanIssueTypeSchemeMapping> getIssueTypeSchemesMapping(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> issueTypeSchemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/mapping");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (issueTypeSchemeId.isPresent()) {
            queryParams.put("issueTypeSchemeId", RestClientUtil.objectCollectionToStringCollection((Collection)issueTypeSchemeId.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueTypeSchemesMapping);
    }

    public Single<Object> removeIssueTypeFromIssueTypeScheme(Long issueTypeSchemeId, Long issueTypeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/{issueTypeSchemeId}/issuetype/{issueTypeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueTypeSchemeId", String.valueOf(issueTypeSchemeId));
        pathParams.put("issueTypeId", String.valueOf(issueTypeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_removeIssueTypeFromIssueTypeScheme);
    }

    public Single<Object> reorderIssueTypesInIssueTypeScheme(Long issueTypeSchemeId, OrderOfIssueTypes orderOfIssueTypes, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/{issueTypeSchemeId}/issuetype/move");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueTypeSchemeId", String.valueOf(issueTypeSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(orderOfIssueTypes));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_reorderIssueTypesInIssueTypeScheme);
    }

    public Single<Object> updateIssueTypeScheme(Long issueTypeSchemeId, IssueTypeSchemeUpdateDetails issueTypeSchemeUpdateDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetypescheme/{issueTypeSchemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueTypeSchemeId", String.valueOf(issueTypeSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeSchemeUpdateDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateIssueTypeScheme);
    }
}

