/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueMatches;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssuePickerSuggestions;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssuesAndJQLQueries;
import org.everit.atlassian.restclient.jiracloud.v3.model.SearchRequestBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.SearchResults;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueSearchApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<IssuePickerSuggestions> returnType_getIssuePickerResource = new TypeReference<IssuePickerSuggestions>(){};
    private static final TypeReference<IssueMatches> returnType_matchIssues = new TypeReference<IssueMatches>(){};
    private static final TypeReference<SearchResults> returnType_searchForIssuesUsingJql = new TypeReference<SearchResults>(){};
    private static final TypeReference<SearchResults> returnType_searchForIssuesUsingJqlPost = new TypeReference<SearchResults>(){};
    private final RestClient restClient;

    public IssueSearchApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<IssuePickerSuggestions> getIssuePickerResource(Optional<String> query, Optional<String> currentJQL, Optional<String> currentIssueKey, Optional<String> currentProjectId, Optional<Boolean> showSubTasks, Optional<Boolean> showSubTaskParent, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issue/picker");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (currentJQL.isPresent()) {
            queryParams.put("currentJQL", Collections.singleton(String.valueOf(currentJQL.get())));
        }
        if (currentIssueKey.isPresent()) {
            queryParams.put("currentIssueKey", Collections.singleton(String.valueOf(currentIssueKey.get())));
        }
        if (currentProjectId.isPresent()) {
            queryParams.put("currentProjectId", Collections.singleton(String.valueOf(currentProjectId.get())));
        }
        if (showSubTasks.isPresent()) {
            queryParams.put("showSubTasks", Collections.singleton(String.valueOf(showSubTasks.get())));
        }
        if (showSubTaskParent.isPresent()) {
            queryParams.put("showSubTaskParent", Collections.singleton(String.valueOf(showSubTaskParent.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssuePickerResource);
    }

    public Single<IssueMatches> matchIssues(IssuesAndJQLQueries issuesAndJQLQueries, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/jql/match");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issuesAndJQLQueries));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_matchIssues);
    }

    public Single<SearchResults> searchForIssuesUsingJql(Optional<String> jql, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<String> validateQuery, Optional<List<String>> fields, Optional<String> expand, Optional<List<String>> properties, Optional<Boolean> fieldsByKeys, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (jql.isPresent()) {
            queryParams.put("jql", Collections.singleton(String.valueOf(jql.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (validateQuery.isPresent()) {
            queryParams.put("validateQuery", Collections.singleton(String.valueOf(validateQuery.get())));
        }
        if (fields.isPresent()) {
            queryParams.put("fields", RestClientUtil.objectCollectionToStringCollection((Collection)fields.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        if (fieldsByKeys.isPresent()) {
            queryParams.put("fieldsByKeys", Collections.singleton(String.valueOf(fieldsByKeys.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchForIssuesUsingJql);
    }

    public Single<SearchResults> searchForIssuesUsingJqlPost(SearchRequestBean searchRequestBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(searchRequestBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchForIssuesUsingJqlPost);
    }
}

