/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.BulkIssuePropertyUpdateRequest;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueFilterForBulkPropertyDelete;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;

public class IssuePropertyBulkUpdateApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private final RestClient restClient;

    public IssuePropertyBulkUpdateApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Completable bulkDeleteIssueProperty(String propertyKey, IssueFilterForBulkPropertyDelete issueFilterForBulkPropertyDelete, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issue/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueFilterForBulkPropertyDelete));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable bulkSetIssueProperty(String propertyKey, BulkIssuePropertyUpdateRequest bulkIssuePropertyUpdateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issue/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(bulkIssuePropertyUpdateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }
}

