/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.CreateCustomFieldContext;
import org.everit.atlassian.restclient.jiracloud.v3.model.CustomFieldContextDefaultValueUpdate;
import org.everit.atlassian.restclient.jiracloud.v3.model.CustomFieldContextUpdateDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeIDs;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanContextForProjectAndIssueType;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanCustomFieldContext;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanCustomFieldContextDefaultValue;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanCustomFieldContextProjectMapping;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanIssueTypeToContextMapping;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectIds;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectIssueTypeMappings;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueCustomFieldContextsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_addIssueTypesToContext = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_assignProjectsToCustomFieldContext = new TypeReference<Object>(){};
    private static final TypeReference<CreateCustomFieldContext> returnType_createCustomFieldContext = new TypeReference<CreateCustomFieldContext>(){};
    private static final TypeReference<Object> returnType_deleteCustomFieldContext = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanCustomFieldContext> returnType_getContextsForField = new TypeReference<PageBeanCustomFieldContext>(){};
    private static final TypeReference<PageBeanContextForProjectAndIssueType> returnType_getCustomFieldContextsForProjectsAndIssueTypes = new TypeReference<PageBeanContextForProjectAndIssueType>(){};
    private static final TypeReference<PageBeanCustomFieldContextDefaultValue> returnType_getDefaultValues = new TypeReference<PageBeanCustomFieldContextDefaultValue>(){};
    private static final TypeReference<PageBeanIssueTypeToContextMapping> returnType_getIssueTypeMappingsForContexts = new TypeReference<PageBeanIssueTypeToContextMapping>(){};
    private static final TypeReference<PageBeanCustomFieldContextProjectMapping> returnType_getProjectContextMapping = new TypeReference<PageBeanCustomFieldContextProjectMapping>(){};
    private static final TypeReference<Object> returnType_removeCustomFieldContextFromProjects = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_removeIssueTypesFromContext = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_setDefaultValues = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateCustomFieldContext = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueCustomFieldContextsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addIssueTypesToContext(String fieldId, Long contextId, IssueTypeIDs issueTypeIDs, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/{contextId}/issuetype");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeIDs));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addIssueTypesToContext);
    }

    public Single<Object> assignProjectsToCustomFieldContext(String fieldId, Long contextId, ProjectIds projectIds, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/{contextId}/project");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectIds));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignProjectsToCustomFieldContext);
    }

    public Single<CreateCustomFieldContext> createCustomFieldContext(String fieldId, CreateCustomFieldContext createCustomFieldContext, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(createCustomFieldContext));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createCustomFieldContext);
    }

    public Single<Object> deleteCustomFieldContext(String fieldId, Long contextId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/{contextId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteCustomFieldContext);
    }

    public Single<PageBeanCustomFieldContext> getContextsForField(String fieldId, Optional<Boolean> isAnyIssueType, Optional<Boolean> isGlobalContext, Optional<List<Long>> contextId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (isAnyIssueType.isPresent()) {
            queryParams.put("isAnyIssueType", Collections.singleton(String.valueOf(isAnyIssueType.get())));
        }
        if (isGlobalContext.isPresent()) {
            queryParams.put("isGlobalContext", Collections.singleton(String.valueOf(isGlobalContext.get())));
        }
        if (contextId.isPresent()) {
            queryParams.put("contextId", RestClientUtil.objectCollectionToStringCollection((Collection)contextId.get()));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getContextsForField);
    }

    public Single<PageBeanContextForProjectAndIssueType> getCustomFieldContextsForProjectsAndIssueTypes(String fieldId, ProjectIssueTypeMappings projectIssueTypeMappings, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/mapping");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectIssueTypeMappings));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getCustomFieldContextsForProjectsAndIssueTypes);
    }

    public Single<PageBeanCustomFieldContextDefaultValue> getDefaultValues(String fieldId, Optional<List<Long>> contextId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/defaultValue");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (contextId.isPresent()) {
            queryParams.put("contextId", RestClientUtil.objectCollectionToStringCollection((Collection)contextId.get()));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDefaultValues);
    }

    public Single<PageBeanIssueTypeToContextMapping> getIssueTypeMappingsForContexts(String fieldId, Optional<List<Long>> contextId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/issuetypemapping");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (contextId.isPresent()) {
            queryParams.put("contextId", RestClientUtil.objectCollectionToStringCollection((Collection)contextId.get()));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueTypeMappingsForContexts);
    }

    public Single<PageBeanCustomFieldContextProjectMapping> getProjectContextMapping(String fieldId, Optional<List<Long>> contextId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/projectmapping");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (contextId.isPresent()) {
            queryParams.put("contextId", RestClientUtil.objectCollectionToStringCollection((Collection)contextId.get()));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectContextMapping);
    }

    public Single<Object> removeCustomFieldContextFromProjects(String fieldId, Long contextId, ProjectIds projectIds, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/{contextId}/project/remove");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectIds));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_removeCustomFieldContextFromProjects);
    }

    public Single<Object> removeIssueTypesFromContext(String fieldId, Long contextId, IssueTypeIDs issueTypeIDs, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/{contextId}/issuetype/remove");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeIDs));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_removeIssueTypesFromContext);
    }

    public Single<Object> setDefaultValues(String fieldId, CustomFieldContextDefaultValueUpdate customFieldContextDefaultValueUpdate, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/defaultValue");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(customFieldContextDefaultValueUpdate));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setDefaultValues);
    }

    public Single<Object> updateCustomFieldContext(String fieldId, Long contextId, CustomFieldContextUpdateDetails customFieldContextUpdateDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/field/{fieldId}/context/{contextId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(customFieldContextUpdateDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateCustomFieldContext);
    }
}

