/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.CustomFieldConfigurations;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanContextualConfiguration;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueCustomFieldConfigurationAppsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<PageBeanContextualConfiguration> returnType_getCustomFieldConfiguration = new TypeReference<PageBeanContextualConfiguration>(){};
    private static final TypeReference<Object> returnType_updateCustomFieldConfiguration = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueCustomFieldConfigurationAppsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<PageBeanContextualConfiguration> getCustomFieldConfiguration(String fieldIdOrKey, Optional<List<Long>> contextId, Optional<Long> issueId, Optional<String> projectKeyOrId, Optional<String> issueTypeId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/app/field/{fieldIdOrKey}/context/configuration");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldIdOrKey", String.valueOf(fieldIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (contextId.isPresent()) {
            queryParams.put("contextId", RestClientUtil.objectCollectionToStringCollection((Collection)contextId.get()));
        }
        if (issueId.isPresent()) {
            queryParams.put("issueId", Collections.singleton(String.valueOf(issueId.get())));
        }
        if (projectKeyOrId.isPresent()) {
            queryParams.put("projectKeyOrId", Collections.singleton(String.valueOf(projectKeyOrId.get())));
        }
        if (issueTypeId.isPresent()) {
            queryParams.put("issueTypeId", Collections.singleton(String.valueOf(issueTypeId.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getCustomFieldConfiguration);
    }

    public Single<Object> updateCustomFieldConfiguration(String fieldIdOrKey, CustomFieldConfigurations customFieldConfigurations, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/app/field/{fieldIdOrKey}/context/configuration");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldIdOrKey", String.valueOf(fieldIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(customFieldConfigurations));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateCustomFieldConfiguration);
    }
}

