/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.EntityProperty;
import org.everit.atlassian.restclient.jiracloud.v3.model.OperationMessage;
import org.everit.atlassian.restclient.jiracloud.v3.model.PropertyKeys;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class AddonPropertiesApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<PropertyKeys> returnType_getAddonProperties = new TypeReference<PropertyKeys>(){};
    private static final TypeReference<EntityProperty> returnType_getAddonProperty = new TypeReference<EntityProperty>(){};
    private static final TypeReference<OperationMessage> returnType_putAddonProperty = new TypeReference<OperationMessage>(){};
    private final RestClient restClient;

    public AddonPropertiesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Completable deleteAddonProperty(String addonKey, String propertyKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("addonKey", String.valueOf(addonKey));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<PropertyKeys> getAddonProperties(String addonKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/addons/{addonKey}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("addonKey", String.valueOf(addonKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAddonProperties);
    }

    public Single<EntityProperty> getAddonProperty(String addonKey, String propertyKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("addonKey", String.valueOf(addonKey));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAddonProperty);
    }

    public Single<OperationMessage> putAddonProperty(String addonKey, String propertyKey, Object body, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("addonKey", String.valueOf(addonKey));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_putAddonProperty);
    }
}

