/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.EntityProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.Visibility;

@ApiModel(description="Details of a worklog.")
public class Worklog {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="author")
    private UserDetails author;
    @JsonProperty(value="updateAuthor")
    private UserDetails updateAuthor;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="updated")
    private OffsetDateTime updated;
    @JsonProperty(value="visibility")
    private Visibility visibility;
    @JsonProperty(value="started")
    private OffsetDateTime started;
    @JsonProperty(value="timeSpent")
    private String timeSpent;
    @JsonProperty(value="timeSpentSeconds")
    private Long timeSpentSeconds;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="issueId")
    private String issueId;
    @JsonProperty(value="properties")
    private List<EntityProperty> properties = new ArrayList<EntityProperty>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    @ApiModelProperty(value="The URL of the worklog item.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="Details of the user who created the worklog.")
    public UserDetails getAuthor() {
        return this.author;
    }

    @ApiModelProperty(value="Details of the user who last updated the worklog.")
    public UserDetails getUpdateAuthor() {
        return this.updateAuthor;
    }

    public Worklog comment(String comment) {
        this.comment = comment;
        return this;
    }

    @ApiModelProperty(value="A comment about the worklog. Optional when creating or updating a worklog.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @ApiModelProperty(value="The datetime on which the worklog was created.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @ApiModelProperty(value="The datetime on which the worklog was last updated.")
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public Worklog visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(value="Details about any restrictions in the visibility of the worklog. Optional when creating or updating a worklog.")
    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Worklog started(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    @ApiModelProperty(value="The datetime on which the worklog effort was started. Required when creating a worklog. Optional when updating a worklog.")
    public OffsetDateTime getStarted() {
        return this.started;
    }

    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    public Worklog timeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
        return this;
    }

    @ApiModelProperty(value="The time spent working on the issue as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). Required when creating a worklog if `timeSpentSeconds` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpentSecond` is provided.")
    public String getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Worklog timeSpentSeconds(Long timeSpentSeconds) {
        this.timeSpentSeconds = timeSpentSeconds;
        return this;
    }

    @ApiModelProperty(value="The time in seconds spent working on the issue. Required when creating a worklog if `timeSpent` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpent` is provided.")
    public Long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }

    public void setTimeSpentSeconds(Long timeSpentSeconds) {
        this.timeSpentSeconds = timeSpentSeconds;
    }

    @ApiModelProperty(value="The ID of the worklog record.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the issue this worklog is for.")
    public String getIssueId() {
        return this.issueId;
    }

    public Worklog properties(List<EntityProperty> properties) {
        this.properties = properties;
        return this;
    }

    public Worklog addPropertiesItem(EntityProperty propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<EntityProperty>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Details of properties for the worklog. Optional when creating or updating a worklog.")
    public List<EntityProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<EntityProperty> properties) {
        this.properties = properties;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Worklog worklog = (Worklog)o;
        return Objects.equals(this.self, worklog.self) && Objects.equals(this.author, worklog.author) && Objects.equals(this.updateAuthor, worklog.updateAuthor) && Objects.equals(this.comment, worklog.comment) && Objects.equals(this.created, worklog.created) && Objects.equals(this.updated, worklog.updated) && Objects.equals(this.visibility, worklog.visibility) && Objects.equals(this.started, worklog.started) && Objects.equals(this.timeSpent, worklog.timeSpent) && Objects.equals(this.timeSpentSeconds, worklog.timeSpentSeconds) && Objects.equals(this.id, worklog.id) && Objects.equals(this.issueId, worklog.issueId) && Objects.equals(this.properties, worklog.properties) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.author, this.updateAuthor, this.comment, this.created, this.updated, this.visibility, this.started, this.timeSpent, this.timeSpentSeconds, this.id, this.issueId, this.properties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Worklog {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    updateAuthor: ").append(this.toIndentedString(this.updateAuthor)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    timeSpent: ").append(this.toIndentedString(this.timeSpent)).append("\n");
        sb.append("    timeSpentSeconds: ").append(this.toIndentedString(this.timeSpentSeconds)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issueId: ").append(this.toIndentedString(this.issueId)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

