/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowTransitionRules;

@ApiModel(description="Details of workflow transition rules.")
public class WorkflowRulesSearchDetails {
    @JsonProperty(value="workflowEntityId")
    private UUID workflowEntityId;
    @JsonProperty(value="invalidRules")
    private List<UUID> invalidRules = new ArrayList<UUID>();
    @JsonProperty(value="validRules")
    private List<WorkflowTransitionRules> validRules = new ArrayList<WorkflowTransitionRules>();

    public WorkflowRulesSearchDetails workflowEntityId(UUID workflowEntityId) {
        this.workflowEntityId = workflowEntityId;
        return this;
    }

    @ApiModelProperty(example="a498d711-685d-428d-8c3e-bc03bb450ea7", value="The workflow ID.")
    public UUID getWorkflowEntityId() {
        return this.workflowEntityId;
    }

    public void setWorkflowEntityId(UUID workflowEntityId) {
        this.workflowEntityId = workflowEntityId;
    }

    public WorkflowRulesSearchDetails invalidRules(List<UUID> invalidRules) {
        this.invalidRules = invalidRules;
        return this;
    }

    public WorkflowRulesSearchDetails addInvalidRulesItem(UUID invalidRulesItem) {
        if (this.invalidRules == null) {
            this.invalidRules = new ArrayList<UUID>();
        }
        this.invalidRules.add(invalidRulesItem);
        return this;
    }

    @ApiModelProperty(value="List of workflow rule IDs that do not belong to the workflow or can not be found.")
    public List<UUID> getInvalidRules() {
        return this.invalidRules;
    }

    public void setInvalidRules(List<UUID> invalidRules) {
        this.invalidRules = invalidRules;
    }

    public WorkflowRulesSearchDetails validRules(List<WorkflowTransitionRules> validRules) {
        this.validRules = validRules;
        return this;
    }

    public WorkflowRulesSearchDetails addValidRulesItem(WorkflowTransitionRules validRulesItem) {
        if (this.validRules == null) {
            this.validRules = new ArrayList<WorkflowTransitionRules>();
        }
        this.validRules.add(validRulesItem);
        return this;
    }

    @ApiModelProperty(value="List of valid workflow transition rules.")
    public List<WorkflowTransitionRules> getValidRules() {
        return this.validRules;
    }

    public void setValidRules(List<WorkflowTransitionRules> validRules) {
        this.validRules = validRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRulesSearchDetails workflowRulesSearchDetails = (WorkflowRulesSearchDetails)o;
        return Objects.equals(this.workflowEntityId, workflowRulesSearchDetails.workflowEntityId) && Objects.equals(this.invalidRules, workflowRulesSearchDetails.invalidRules) && Objects.equals(this.validRules, workflowRulesSearchDetails.validRules);
    }

    public int hashCode() {
        return Objects.hash(this.workflowEntityId, this.invalidRules, this.validRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowRulesSearchDetails {\n");
        sb.append("    workflowEntityId: ").append(this.toIndentedString(this.workflowEntityId)).append("\n");
        sb.append("    invalidRules: ").append(this.toIndentedString(this.invalidRules)).append("\n");
        sb.append("    validRules: ").append(this.toIndentedString(this.validRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

