/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="A user found in a search.")
public class UserPickerUser {
    @JsonProperty(value="accountId")
    private String accountId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="html")
    private String html;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="avatarUrl")
    private URI avatarUrl;

    public UserPickerUser accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public UserPickerUser name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available . See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserPickerUser key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UserPickerUser html(String html) {
        this.html = html;
        return this;
    }

    @ApiModelProperty(value="The display name, email address, and key of the user with the matched query string highlighted with the HTML bold tag.")
    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public UserPickerUser displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The display name of the user. Depending on the user\u2019s privacy setting, this may be returned as null.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserPickerUser avatarUrl(URI avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @ApiModelProperty(value="The avatar URL of the user.")
    public URI getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(URI avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPickerUser userPickerUser = (UserPickerUser)o;
        return Objects.equals(this.accountId, userPickerUser.accountId) && Objects.equals(this.name, userPickerUser.name) && Objects.equals(this.key, userPickerUser.key) && Objects.equals(this.html, userPickerUser.html) && Objects.equals(this.displayName, userPickerUser.displayName) && Objects.equals(this.avatarUrl, userPickerUser.avatarUrl);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.name, this.key, this.html, this.displayName, this.avatarUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPickerUser {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    html: ").append(this.toIndentedString(this.html)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

