/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about the project.")
public class UpdateProjectDetails {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="lead")
    private String lead;
    @JsonProperty(value="leadAccountId")
    private String leadAccountId;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="assigneeType")
    private AssigneeTypeEnum assigneeType;
    @JsonProperty(value="avatarId")
    private Long avatarId;
    @JsonProperty(value="issueSecurityScheme")
    private Long issueSecurityScheme;
    @JsonProperty(value="permissionScheme")
    private Long permissionScheme;
    @JsonProperty(value="notificationScheme")
    private Long notificationScheme;
    @JsonProperty(value="categoryId")
    private Long categoryId;

    public UpdateProjectDetails key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UpdateProjectDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the project.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateProjectDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A brief description of the project.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateProjectDetails lead(String lead) {
        this.lead = lead;
        return this;
    }

    @ApiModelProperty(value="This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Cannot be provided with `leadAccountId`.")
    public String getLead() {
        return this.lead;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public UpdateProjectDetails leadAccountId(String leadAccountId) {
        this.leadAccountId = leadAccountId;
        return this;
    }

    @ApiModelProperty(value="The account ID of the project lead. Cannot be provided with `lead`.")
    public String getLeadAccountId() {
        return this.leadAccountId;
    }

    public void setLeadAccountId(String leadAccountId) {
        this.leadAccountId = leadAccountId;
    }

    public UpdateProjectDetails url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="A link to information about this project, such as project documentation")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UpdateProjectDetails assigneeType(AssigneeTypeEnum assigneeType) {
        this.assigneeType = assigneeType;
        return this;
    }

    @ApiModelProperty(value="The default assignee when creating issues for this project.")
    public AssigneeTypeEnum getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(AssigneeTypeEnum assigneeType) {
        this.assigneeType = assigneeType;
    }

    public UpdateProjectDetails avatarId(Long avatarId) {
        this.avatarId = avatarId;
        return this;
    }

    @ApiModelProperty(value="An integer value for the project's avatar.")
    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    public UpdateProjectDetails issueSecurityScheme(Long issueSecurityScheme) {
        this.issueSecurityScheme = issueSecurityScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-2-issuesecurityschemes-get) resource to get all issue security scheme IDs.")
    public Long getIssueSecurityScheme() {
        return this.issueSecurityScheme;
    }

    public void setIssueSecurityScheme(Long issueSecurityScheme) {
        this.issueSecurityScheme = issueSecurityScheme;
    }

    public UpdateProjectDetails permissionScheme(Long permissionScheme) {
        this.permissionScheme = permissionScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-2-permissionscheme-get) resource to see a list of all permission scheme IDs.")
    public Long getPermissionScheme() {
        return this.permissionScheme;
    }

    public void setPermissionScheme(Long permissionScheme) {
        this.permissionScheme = permissionScheme;
    }

    public UpdateProjectDetails notificationScheme(Long notificationScheme) {
        this.notificationScheme = notificationScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-2-notificationscheme-get) resource to get a list of notification scheme IDs.")
    public Long getNotificationScheme() {
        return this.notificationScheme;
    }

    public void setNotificationScheme(Long notificationScheme) {
        this.notificationScheme = notificationScheme;
    }

    public UpdateProjectDetails categoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-2-projectCategory-get) operation.")
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateProjectDetails updateProjectDetails = (UpdateProjectDetails)o;
        return Objects.equals(this.key, updateProjectDetails.key) && Objects.equals(this.name, updateProjectDetails.name) && Objects.equals(this.description, updateProjectDetails.description) && Objects.equals(this.lead, updateProjectDetails.lead) && Objects.equals(this.leadAccountId, updateProjectDetails.leadAccountId) && Objects.equals(this.url, updateProjectDetails.url) && Objects.equals((Object)this.assigneeType, (Object)updateProjectDetails.assigneeType) && Objects.equals(this.avatarId, updateProjectDetails.avatarId) && Objects.equals(this.issueSecurityScheme, updateProjectDetails.issueSecurityScheme) && Objects.equals(this.permissionScheme, updateProjectDetails.permissionScheme) && Objects.equals(this.notificationScheme, updateProjectDetails.notificationScheme) && Objects.equals(this.categoryId, updateProjectDetails.categoryId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.name, this.description, this.lead, this.leadAccountId, this.url, this.assigneeType, this.avatarId, this.issueSecurityScheme, this.permissionScheme, this.notificationScheme, this.categoryId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateProjectDetails {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lead: ").append(this.toIndentedString(this.lead)).append("\n");
        sb.append("    leadAccountId: ").append(this.toIndentedString(this.leadAccountId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    assigneeType: ").append(this.toIndentedString((Object)this.assigneeType)).append("\n");
        sb.append("    avatarId: ").append(this.toIndentedString(this.avatarId)).append("\n");
        sb.append("    issueSecurityScheme: ").append(this.toIndentedString(this.issueSecurityScheme)).append("\n");
        sb.append("    permissionScheme: ").append(this.toIndentedString(this.permissionScheme)).append("\n");
        sb.append("    notificationScheme: ").append(this.toIndentedString(this.notificationScheme)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AssigneeTypeEnum {
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private AssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssigneeTypeEnum fromValue(String value) {
            for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

