/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.GroupName;
import org.everit.atlassian.restclient.jiracloud.v2.model.Project;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectRole;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserBean;

@ApiModel(description="Details of a share permission for the filter.")
public class SharePermission {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="project")
    private Project project;
    @JsonProperty(value="role")
    private ProjectRole role;
    @JsonProperty(value="group")
    private GroupName group;
    @JsonProperty(value="user")
    private UserBean user;

    @ApiModelProperty(value="The unique identifier of the share permission.")
    public Long getId() {
        return this.id;
    }

    public SharePermission type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of share permission:   *  `user` Shared with a user.  *  `group` Shared with a group. If set in a request, then specify `sharePermission.group` as well.  *  `project` Shared with a project. If set in a request, then specify `sharePermission.project` as well.  *  `projectRole` Share with a project role in a project. This value is not returned in responses. It is used in requests, where it needs to be specify with `projectId` and `projectRoleId`.  *  `global` Shared globally. If set in a request, no other `sharePermission` properties need to be specified.  *  `loggedin` Shared with all logged-in users. Note: This value is set in a request by specifying `authenticated` as the `type`.  *  `project-unknown` Shared with a project that the user does not have access to. Cannot be set in a request.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SharePermission project(Project project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(value="The project that the filter is shared with. This is similar to the project object returned by [Get project](#api-rest-api-2-project-projectIdOrKey-get) but it contains a subset of the properties, which are: `self`, `id`, `key`, `assigneeType`, `name`, `roles`, `avatarUrls`, `projectType`, `simplified`.   For a request, specify the `id` for the project.")
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public SharePermission role(ProjectRole role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(value="The project role that the filter is shared with.   For a request, specify the `id` for the role. You must also specify the `project` object and `id` for the project that the role is in.")
    public ProjectRole getRole() {
        return this.role;
    }

    public void setRole(ProjectRole role) {
        this.role = role;
    }

    public SharePermission group(GroupName group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="The group that the filter is shared with. For a request, specify the `name` property for the group.")
    public GroupName getGroup() {
        return this.group;
    }

    public void setGroup(GroupName group) {
        this.group = group;
    }

    public SharePermission user(UserBean user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.")
    public UserBean getUser() {
        return this.user;
    }

    public void setUser(UserBean user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharePermission sharePermission = (SharePermission)o;
        return Objects.equals(this.id, sharePermission.id) && Objects.equals((Object)this.type, (Object)sharePermission.type) && Objects.equals(this.project, sharePermission.project) && Objects.equals(this.role, sharePermission.role) && Objects.equals(this.group, sharePermission.group) && Objects.equals(this.user, sharePermission.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.project, this.role, this.group, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SharePermission {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        USER("user"),
        GROUP("group"),
        PROJECT("project"),
        PROJECTROLE("projectRole"),
        GLOBAL("global"),
        LOGGEDIN("loggedin"),
        AUTHENTICATED("authenticated"),
        PROJECT_UNKNOWN("project-unknown");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

