/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A rule configuration.")
public class RuleConfiguration {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="disabled")
    private Boolean disabled = false;
    @JsonProperty(value="tag")
    private String tag;

    public RuleConfiguration value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Configuration of the rule, as it is stored by the Connect app on the rule configuration page.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RuleConfiguration disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(value="EXPERIMENTAL: Whether the rule is disabled.")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public RuleConfiguration tag(String tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="EXPERIMENTAL: A tag used to filter rules in [Get workflow transition rule configurations](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflow-transition-rules/#api-rest-api-3-workflow-rule-config-get).")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleConfiguration ruleConfiguration = (RuleConfiguration)o;
        return Objects.equals(this.value, ruleConfiguration.value) && Objects.equals(this.disabled, ruleConfiguration.disabled) && Objects.equals(this.tag, ruleConfiguration.tag);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.disabled, this.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuleConfiguration {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

