/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of a user, group, field, or project role that holds a permission. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.")
public class PermissionHolder {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="parameter")
    private String parameter;
    @JsonProperty(value="expand")
    private String expand;

    public PermissionHolder type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of permission holder.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PermissionHolder parameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    @ApiModelProperty(value="The identifier of permission holder.")
    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    @ApiModelProperty(value="Expand options that include additional permission holder details in the response.")
    public String getExpand() {
        return this.expand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionHolder permissionHolder = (PermissionHolder)o;
        return Objects.equals(this.type, permissionHolder.type) && Objects.equals(this.parameter, permissionHolder.parameter) && Objects.equals(this.expand, permissionHolder.expand);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.parameter, this.expand);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionHolder {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    parameter: ").append(this.toIndentedString(this.parameter)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

