/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionHolder;

@ApiModel(description="Details about a permission granted to a user or group.")
public class PermissionGrant {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="holder")
    private PermissionHolder holder;
    @JsonProperty(value="permission")
    private String permission;

    @ApiModelProperty(value="The ID of the permission granted details.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The URL of the permission granted details.")
    public URI getSelf() {
        return this.self;
    }

    public PermissionGrant holder(PermissionHolder holder) {
        this.holder = holder;
        return this;
    }

    @ApiModelProperty(value="The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.")
    public PermissionHolder getHolder() {
        return this.holder;
    }

    public void setHolder(PermissionHolder holder) {
        this.holder = holder;
    }

    public PermissionGrant permission(String permission) {
        this.permission = permission;
        return this;
    }

    @ApiModelProperty(value="The permission to grant. This permission can be one of the built-in permissions or a custom permission added by an app. See [Built-in permissions](../api-group-permission-schemes/#built-in-permissions) in *Get all permission schemes* for more information about the built-in permissions. See the [project permission](https://developer.atlassian.com/cloud/jira/platform/modules/project-permission/) and [global permission](https://developer.atlassian.com/cloud/jira/platform/modules/global-permission/) module documentation for more information about custom permissions.")
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGrant permissionGrant = (PermissionGrant)o;
        return Objects.equals(this.id, permissionGrant.id) && Objects.equals(this.self, permissionGrant.self) && Objects.equals(this.holder, permissionGrant.holder) && Objects.equals(this.permission, permissionGrant.permission);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.self, this.holder, this.permission);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionGrant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    holder: ").append(this.toIndentedString(this.holder)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

