/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.GroupName;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserDetails;

@ApiModel(description="Details of the users and groups to receive the notification.")
public class NotificationRecipients {
    @JsonProperty(value="reporter")
    private Boolean reporter;
    @JsonProperty(value="assignee")
    private Boolean assignee;
    @JsonProperty(value="watchers")
    private Boolean watchers;
    @JsonProperty(value="voters")
    private Boolean voters;
    @JsonProperty(value="users")
    private List<UserDetails> users = new ArrayList<UserDetails>();
    @JsonProperty(value="groups")
    private List<GroupName> groups = new ArrayList<GroupName>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public NotificationRecipients reporter(Boolean reporter) {
        this.reporter = reporter;
        return this;
    }

    @ApiModelProperty(value="Whether the notification should be sent to the issue's reporter.")
    public Boolean getReporter() {
        return this.reporter;
    }

    public void setReporter(Boolean reporter) {
        this.reporter = reporter;
    }

    public NotificationRecipients assignee(Boolean assignee) {
        this.assignee = assignee;
        return this;
    }

    @ApiModelProperty(value="Whether the notification should be sent to the issue's assignees.")
    public Boolean getAssignee() {
        return this.assignee;
    }

    public void setAssignee(Boolean assignee) {
        this.assignee = assignee;
    }

    public NotificationRecipients watchers(Boolean watchers) {
        this.watchers = watchers;
        return this;
    }

    @ApiModelProperty(value="Whether the notification should be sent to the issue's watchers.")
    public Boolean getWatchers() {
        return this.watchers;
    }

    public void setWatchers(Boolean watchers) {
        this.watchers = watchers;
    }

    public NotificationRecipients voters(Boolean voters) {
        this.voters = voters;
        return this;
    }

    @ApiModelProperty(value="Whether the notification should be sent to the issue's voters.")
    public Boolean getVoters() {
        return this.voters;
    }

    public void setVoters(Boolean voters) {
        this.voters = voters;
    }

    public NotificationRecipients users(List<UserDetails> users) {
        this.users = users;
        return this;
    }

    public NotificationRecipients addUsersItem(UserDetails usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<UserDetails>();
        }
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(value="List of users to receive the notification.")
    public List<UserDetails> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserDetails> users) {
        this.users = users;
    }

    public NotificationRecipients groups(List<GroupName> groups) {
        this.groups = groups;
        return this;
    }

    public NotificationRecipients addGroupsItem(GroupName groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<GroupName>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="List of groups to receive the notification.")
    public List<GroupName> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GroupName> groups) {
        this.groups = groups;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRecipients notificationRecipients = (NotificationRecipients)o;
        return Objects.equals(this.reporter, notificationRecipients.reporter) && Objects.equals(this.assignee, notificationRecipients.assignee) && Objects.equals(this.watchers, notificationRecipients.watchers) && Objects.equals(this.voters, notificationRecipients.voters) && Objects.equals(this.users, notificationRecipients.users) && Objects.equals(this.groups, notificationRecipients.groups) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.reporter, this.assignee, this.watchers, this.voters, this.users, this.groups, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationRecipients {\n");
        sb.append("    reporter: ").append(this.toIndentedString(this.reporter)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    watchers: ").append(this.toIndentedString(this.watchers)).append("\n");
        sb.append("    voters: ").append(this.toIndentedString(this.voters)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

