/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about a notification event.")
public class NotificationEvent {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="templateEvent")
    private NotificationEvent templateEvent;

    public NotificationEvent id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the event. The event can be a [Jira system event](https://confluence.atlassian.com/x/8YdKLg#Creatinganotificationscheme-eventsEvents) or a [custom event](https://confluence.atlassian.com/x/AIlKLg).")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public NotificationEvent name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the event.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotificationEvent description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the event.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NotificationEvent templateEvent(NotificationEvent templateEvent) {
        this.templateEvent = templateEvent;
        return this;
    }

    @ApiModelProperty(value="The template of the event. Only custom events configured by Jira administrators have template.")
    public NotificationEvent getTemplateEvent() {
        return this.templateEvent;
    }

    public void setTemplateEvent(NotificationEvent templateEvent) {
        this.templateEvent = templateEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationEvent notificationEvent = (NotificationEvent)o;
        return Objects.equals(this.id, notificationEvent.id) && Objects.equals(this.name, notificationEvent.name) && Objects.equals(this.description, notificationEvent.description) && Objects.equals(this.templateEvent, notificationEvent.templateEvent);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.templateEvent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    templateEvent: ").append(this.toIndentedString(this.templateEvent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

