/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The user details.")
public class NewUserDetails {
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="emailAddress")
    private String emailAddress;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="applicationKeys")
    private List<String> applicationKeys = new ArrayList<String>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    @ApiModelProperty(value="The URL of the user.")
    public String getSelf() {
        return this.self;
    }

    public NewUserDetails key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public NewUserDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NewUserDetails password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available. If the user has an Atlassian account, their password is not changed. If the user does not have an Atlassian account, they are sent an email asking them set up an account.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public NewUserDetails emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address for the user.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public NewUserDetails displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(required=true, value="A suggested display name for the user. If the user has an Atlassian account, their display name is not changed. If the user does not have an Atlassian account, this display name is used as a suggestion for creating an account. The user is sent an email asking them to set their display name and privacy preferences.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public NewUserDetails applicationKeys(List<String> applicationKeys) {
        this.applicationKeys = applicationKeys;
        return this;
    }

    public NewUserDetails addApplicationKeysItem(String applicationKeysItem) {
        if (this.applicationKeys == null) {
            this.applicationKeys = new ArrayList<String>();
        }
        this.applicationKeys.add(applicationKeysItem);
        return this;
    }

    @ApiModelProperty(value="Deprecated, do not use.")
    public List<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    public void setApplicationKeys(List<String> applicationKeys) {
        this.applicationKeys = applicationKeys;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewUserDetails newUserDetails = (NewUserDetails)o;
        return Objects.equals(this.self, newUserDetails.self) && Objects.equals(this.key, newUserDetails.key) && Objects.equals(this.name, newUserDetails.name) && Objects.equals(this.password, newUserDetails.password) && Objects.equals(this.emailAddress, newUserDetails.emailAddress) && Objects.equals(this.displayName, newUserDetails.displayName) && Objects.equals(this.applicationKeys, newUserDetails.applicationKeys) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.key, this.name, this.password, this.emailAddress, this.displayName, this.applicationKeys, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewUserDetails {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    applicationKeys: ").append(this.toIndentedString(this.applicationKeys)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

