/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of an entity property.")
public class JqlQueryFieldEntityProperty {
    @JsonProperty(value="entity")
    private String entity;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="type")
    private TypeEnum type;

    public JqlQueryFieldEntityProperty entity(String entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="issue", required=true, value="The object on which the property is set.")
    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public JqlQueryFieldEntityProperty key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="stats", required=true, value="The key of the property.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public JqlQueryFieldEntityProperty path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="comments.count", required=true, value="The path in the property value to query.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public JqlQueryFieldEntityProperty type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="number", value="The type of the property value extraction. Not available if the extraction for the property is not registered on the instance with the [Entity property](https://developer.atlassian.com/cloud/jira/platform/modules/entity-property/) module.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlQueryFieldEntityProperty jqlQueryFieldEntityProperty = (JqlQueryFieldEntityProperty)o;
        return Objects.equals(this.entity, jqlQueryFieldEntityProperty.entity) && Objects.equals(this.key, jqlQueryFieldEntityProperty.key) && Objects.equals(this.path, jqlQueryFieldEntityProperty.path) && Objects.equals((Object)this.type, (Object)jqlQueryFieldEntityProperty.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.key, this.path, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JqlQueryFieldEntityProperty {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        NUMBER("number"),
        STRING("string"),
        TEXT("text"),
        DATE("date"),
        USER("user");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

