/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.EntityProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.FieldUpdateOperation;
import org.everit.atlassian.restclient.jiracloud.v2.model.HistoryMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTransition;

@ApiModel(description="Details of an issue update request.")
public class IssueUpdateDetails {
    @JsonProperty(value="transition")
    private IssueTransition transition;
    @JsonProperty(value="fields")
    private Map<String, Object> fields = new HashMap<String, Object>();
    @JsonProperty(value="update")
    private Map<String, List<FieldUpdateOperation>> update = new HashMap<String, List<FieldUpdateOperation>>();
    @JsonProperty(value="historyMetadata")
    private HistoryMetadata historyMetadata;
    @JsonProperty(value="properties")
    private List<EntityProperty> properties = new ArrayList<EntityProperty>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public IssueUpdateDetails transition(IssueTransition transition) {
        this.transition = transition;
        return this;
    }

    @ApiModelProperty(value="Details of a transition. Required when performing a transition, optional when creating or editing an issue.")
    public IssueTransition getTransition() {
        return this.transition;
    }

    public void setTransition(IssueTransition transition) {
        this.transition = transition;
    }

    public IssueUpdateDetails fields(Map<String, Object> fields) {
        this.fields = fields;
        return this;
    }

    public IssueUpdateDetails putFieldsItem(String key, Object fieldsItem) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.put(key, fieldsItem);
        return this;
    }

    @ApiModelProperty(value="List of issue screen fields to update, specifying the sub-field to update and its value for each field. This field provides a straightforward option when setting a sub-field. When multiple sub-fields or other operations are required, use `update`. Fields included in here cannot be included in `update`.")
    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public IssueUpdateDetails update(Map<String, List<FieldUpdateOperation>> update) {
        this.update = update;
        return this;
    }

    public IssueUpdateDetails putUpdateItem(String key, List<FieldUpdateOperation> updateItem) {
        if (this.update == null) {
            this.update = new HashMap<String, List<FieldUpdateOperation>>();
        }
        this.update.put(key, updateItem);
        return this;
    }

    @ApiModelProperty(value="List of operations to perform on issue screen fields. Note that fields included in here cannot be included in `fields`.")
    public Map<String, List<FieldUpdateOperation>> getUpdate() {
        return this.update;
    }

    public void setUpdate(Map<String, List<FieldUpdateOperation>> update) {
        this.update = update;
    }

    public IssueUpdateDetails historyMetadata(HistoryMetadata historyMetadata) {
        this.historyMetadata = historyMetadata;
        return this;
    }

    @ApiModelProperty(value="Additional issue history details.")
    public HistoryMetadata getHistoryMetadata() {
        return this.historyMetadata;
    }

    public void setHistoryMetadata(HistoryMetadata historyMetadata) {
        this.historyMetadata = historyMetadata;
    }

    public IssueUpdateDetails properties(List<EntityProperty> properties) {
        this.properties = properties;
        return this;
    }

    public IssueUpdateDetails addPropertiesItem(EntityProperty propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<EntityProperty>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Details of issue properties to be add or update.")
    public List<EntityProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<EntityProperty> properties) {
        this.properties = properties;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueUpdateDetails issueUpdateDetails = (IssueUpdateDetails)o;
        return Objects.equals(this.transition, issueUpdateDetails.transition) && Objects.equals(this.fields, issueUpdateDetails.fields) && Objects.equals(this.update, issueUpdateDetails.update) && Objects.equals(this.historyMetadata, issueUpdateDetails.historyMetadata) && Objects.equals(this.properties, issueUpdateDetails.properties) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.transition, this.fields, this.update, this.historyMetadata, this.properties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueUpdateDetails {\n");
        sb.append("    transition: ").append(this.toIndentedString(this.transition)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    update: ").append(this.toIndentedString(this.update)).append("\n");
        sb.append("    historyMetadata: ").append(this.toIndentedString(this.historyMetadata)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

