/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of an issue type scheme and its associated issue types.")
public class IssueTypeSchemeDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="defaultIssueTypeId")
    private String defaultIssueTypeId;
    @JsonProperty(value="issueTypeIds")
    private List<String> issueTypeIds = new ArrayList<String>();

    public IssueTypeSchemeDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IssueTypeSchemeDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the issue type scheme. The maximum length is 4000 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueTypeSchemeDetails defaultIssueTypeId(String defaultIssueTypeId) {
        this.defaultIssueTypeId = defaultIssueTypeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the default issue type of the issue type scheme. This ID must be included in `issueTypeIds`.")
    public String getDefaultIssueTypeId() {
        return this.defaultIssueTypeId;
    }

    public void setDefaultIssueTypeId(String defaultIssueTypeId) {
        this.defaultIssueTypeId = defaultIssueTypeId;
    }

    public IssueTypeSchemeDetails issueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public IssueTypeSchemeDetails addIssueTypeIdsItem(String issueTypeIdsItem) {
        this.issueTypeIds.add(issueTypeIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of issue types IDs of the issue type scheme. At least one standard issue type ID is required.")
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public void setIssueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeSchemeDetails issueTypeSchemeDetails = (IssueTypeSchemeDetails)o;
        return Objects.equals(this.name, issueTypeSchemeDetails.name) && Objects.equals(this.description, issueTypeSchemeDetails.description) && Objects.equals(this.defaultIssueTypeId, issueTypeSchemeDetails.defaultIssueTypeId) && Objects.equals(this.issueTypeIds, issueTypeSchemeDetails.issueTypeIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.defaultIssueTypeId, this.issueTypeIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeSchemeDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    defaultIssueTypeId: ").append(this.toIndentedString(this.defaultIssueTypeId)).append("\n");
        sb.append("    issueTypeIds: ").append(this.toIndentedString(this.issueTypeIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

