/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A group label.")
public class GroupLabel {
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="type")
    private TypeEnum type;

    public GroupLabel text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="The group label name.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public GroupLabel title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="The title of the group label.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GroupLabel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the group label.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupLabel groupLabel = (GroupLabel)o;
        return Objects.equals(this.text, groupLabel.text) && Objects.equals(this.title, groupLabel.title) && Objects.equals((Object)this.type, (Object)groupLabel.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.title, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupLabel {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ADMIN("ADMIN"),
        SINGLE("SINGLE"),
        MULTIPLE("MULTIPLE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

