/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.FoundGroup;

@ApiModel(description="The list of groups found in a search, including header text (Showing X of Y matching groups) and total of matched groups.")
public class FoundGroups {
    @JsonProperty(value="header")
    private String header;
    @JsonProperty(value="total")
    private Integer total;
    @JsonProperty(value="groups")
    private List<FoundGroup> groups = new ArrayList<FoundGroup>();

    public FoundGroups header(String header) {
        this.header = header;
        return this;
    }

    @ApiModelProperty(value="Header text indicating the number of groups in the response and the total number of groups found in the search.")
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public FoundGroups total(Integer total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="The total number of groups found in the search.")
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public FoundGroups groups(List<FoundGroup> groups) {
        this.groups = groups;
        return this;
    }

    public FoundGroups addGroupsItem(FoundGroup groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<FoundGroup>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<FoundGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<FoundGroup> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoundGroups foundGroups = (FoundGroups)o;
        return Objects.equals(this.header, foundGroups.header) && Objects.equals(this.total, foundGroups.total) && Objects.equals(this.groups, foundGroups.groups);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.total, this.groups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FoundGroups {\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

