/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.FilterSubscription;

@ApiModel(description="A paginated list of subscriptions to a filter.")
public class FilterSubscriptionsList {
    @JsonProperty(value="size")
    private Integer size;
    @JsonProperty(value="items")
    private List<FilterSubscription> items = new ArrayList<FilterSubscription>();
    @JsonProperty(value="max-results")
    private Integer maxResults;
    @JsonProperty(value="start-index")
    private Integer startIndex;
    @JsonProperty(value="end-index")
    private Integer endIndex;

    @ApiModelProperty(value="The number of items on the page.")
    public Integer getSize() {
        return this.size;
    }

    @ApiModelProperty(value="The list of items.")
    public List<FilterSubscription> getItems() {
        return this.items;
    }

    @ApiModelProperty(value="The maximum number of results that could be on the page.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @ApiModelProperty(value="The index of the first item returned on the page.")
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @ApiModelProperty(value="The index of the last item returned on the page.")
    public Integer getEndIndex() {
        return this.endIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterSubscriptionsList filterSubscriptionsList = (FilterSubscriptionsList)o;
        return Objects.equals(this.size, filterSubscriptionsList.size) && Objects.equals(this.items, filterSubscriptionsList.items) && Objects.equals(this.maxResults, filterSubscriptionsList.maxResults) && Objects.equals(this.startIndex, filterSubscriptionsList.startIndex) && Objects.equals(this.endIndex, filterSubscriptionsList.endIndex);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.items, this.maxResults, this.startIndex, this.endIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterSubscriptionsList {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    endIndex: ").append(this.toIndentedString(this.endIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

